<?php

declare(strict_types=1);

namespace Drupal\nexi_xpay\Event;

use Drupal\nexi_xpay\Entity\NexiXpayTransactionInterface;
use Symfony\Contracts\EventDispatcher\Event;

/**
 * The transaction status change event.
 */
final class TransactionStatusChangeEvent extends Event {

  /**
   * The constructor.
   *
   * @param \Drupal\nexi_xpay\Entity\NexiXpayTransactionInterface $transaction
   *   The transaction entity.
   * @param string $oldStatus
   *   The old status.
   * @param string $newStatus
   *   The new status.
   * @param array<string, mixed> $context
   *   Extra context information for callers (debug/logging).
   */
  public function __construct(
    public readonly NexiXpayTransactionInterface $transaction,
    public readonly string $oldStatus,
    public readonly string $newStatus,
    public readonly array $context = [],
  ) {}

}
