<?php

declare(strict_types=1);

namespace Drupal\nexi_xpay\Hook;

use Drupal\Core\Hook\Attribute\Hook;

/**
 * Hooks for the NexiXpay HPP theme.
 */
final class NexiXpayHppThemeHooks {

  /**
   * Implements hook_theme().
   *
   * @return array<string, mixed>
   *   The theme return array.
   */
  #[Hook('theme')]
  public function theme(): array {
    return [
      'nexi_xpay_hpp_pay' => [
        'variables' => [
          'tx' => [],
          'start_url' => '',
        ],
        'template' => 'nexi-xpay-hpp-pay',
      ],
      'nexi_xpay_hpp_return' => [
        'variables' => [
          'tx' => [],
          'message' => '',
        ],
        'template' => 'nexi-xpay-hpp-return',
      ],
    ];
  }

}
