<?php

declare(strict_types=1);

namespace Drupal\nexi_xpay\Plugin\XpayMode;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\nexi_xpay\Entity\NexiXpayTransactionInterface;
use Drupal\nexi_xpay\Value\ModeHandleResult;
use Drupal\nexi_xpay\Value\ModeStartResult;
use Symfony\Component\HttpFoundation\Request;

/**
 * Interface for NexiXpayMode plugins.
 */
interface NexiXpayModeInterface extends PluginInspectionInterface {

  /**
   * Starts the payment process.
   *
   * @param \Drupal\nexi_xpay\Entity\NexiXpayTransactionInterface $transaction
   *   Transaction entity.
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   Current request.
   *
   * @return \Drupal\nexi_xpay\Value\ModeStartResult
   *   Result of starting payment.
   */
  public function startPayment(NexiXpayTransactionInterface $transaction, Request $request): ModeStartResult;

  /**
   * Handle return from Nexi.
   *
   * @param \Drupal\nexi_xpay\Entity\NexiXpayTransactionInterface $transaction
   *   Transaction entity.
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   Current request.
   *
   * @return \Drupal\nexi_xpay\Value\ModeHandleResult
   *   Result of handling return.
   */
  public function handleReturn(NexiXpayTransactionInterface $transaction, Request $request): ModeHandleResult;

  /**
   * Handle notification from Nexi.
   *
   * @param \Drupal\nexi_xpay\Entity\NexiXpayTransactionInterface $transaction
   *   Transaction entity.
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   Current request.
   *
   * @return \Drupal\nexi_xpay\Value\ModeHandleResult
   *   Result of handling notification.
   */
  public function handleNotify(NexiXpayTransactionInterface $transaction, Request $request): ModeHandleResult;

  /**
   * Builds the public pay page (order summary + CTA).
   *
   * @param \Drupal\nexi_xpay\Entity\NexiXpayTransactionInterface $transaction
   *   Transaction entity.
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   Current request.
   *
   * @return array<string, mixed>
   *   Render array for the pay page.
   */
  public function buildPayPage(NexiXpayTransactionInterface $transaction, Request $request): array;

  /**
   * Builds the public return page after handling return logic.
   *
   * @param \Drupal\nexi_xpay\Entity\NexiXpayTransactionInterface $transaction
   *   Transaction entity.
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   Current request.
   * @param \Drupal\nexi_xpay\Value\ModeHandleResult $handleResult
   *   Result of handling return.
   *
   * @return array<string, mixed>
   *   Render array for the return page.
   */
  public function buildReturnPage(NexiXpayTransactionInterface $transaction, Request $request, ModeHandleResult $handleResult): array;

}
