<?php

declare(strict_types=1);

namespace Drupal\nexi_xpay\Plugin\XpayMode;

use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\nexi_xpay\Plugin\XpayMode\Attribute\XpayMode;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;

/**
 * The mode manager for NexiXpay modes.
 */
final class NexiXpayModeManager extends DefaultPluginManager {

  /**
   * Constructs a NexiXpayModeManager object.
   *
   * @param \Traversable<string, string> $namespaces
   *   A traversable array of root paths keyed by the corresponding namespace.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(
    \Traversable $namespaces,
    CacheBackendInterface $cache_backend,
    ModuleHandlerInterface $module_handler,
  ) {
    parent::__construct(
      'Plugin/XpayMode',
      $namespaces,
      $module_handler,
      NexiXpayModeInterface::class,
      XpayMode::class,
    );

    $this->alterInfo('nexi_xpay_mode_info');
    $this->setCacheBackend($cache_backend, 'nexi_xpay_mode_plugins');
  }

}
