<?php

declare(strict_types=1);

namespace Drupal\nexi_xpay\Service;

use Drupal\nexi_xpay\Entity\NexiXpayTransactionInterface;
use Drupal\nexi_xpay\Value\ModeHandleResult;
use Drupal\nexi_xpay\Value\ModeStartResult;
use Symfony\Component\HttpFoundation\Request;

/**
 * Interface for NexiXpayManager.
 */
interface NexiXpayManagerInterface {

  /**
   * Starts the payment process.
   */
  public function startPayment(NexiXpayTransactionInterface $transaction, Request $request): ModeStartResult;

  /**
   * Handles the return from Nexi.
   */
  public function handleReturn(NexiXpayTransactionInterface $transaction, Request $request): ModeHandleResult;

  /**
   * Handles the notification from Nexi.
   */
  public function handleNotify(NexiXpayTransactionInterface $transaction, Request $request): ModeHandleResult;

  /**
   * Builds the public pay page (order summary + CTA).
   *
   * @param \Drupal\nexi_xpay\Entity\NexiXpayTransactionInterface $transaction
   *   The transaction entity.
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The current request.
   *
   * @return array<string, mixed>
   *   Render array for the pay page.
   */
  public function buildPayPage(NexiXpayTransactionInterface $transaction, Request $request): array;

  /**
   * Builds the public return page after handling return logic.
   *
   * @param \Drupal\nexi_xpay\Entity\NexiXpayTransactionInterface $transaction
   *   The transaction entity.
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The current request.
   * @param \Drupal\nexi_xpay\Value\ModeHandleResult $handle
   *   The result of handling the return.
   *
   * @return array<string, mixed>
   *   The render array for the return page.
   */
  public function buildReturnPage(NexiXpayTransactionInterface $transaction, Request $request, ModeHandleResult $handle): array;

}
