<?php

declare(strict_types=1);

namespace Drupal\nexi_xpay\Util;

/**
 * Utility class for casting values to specific types.
 */
final class TypeCast {

  private function __construct() {}

  /**
   * Casts a value to a string.
   */
  public static function toString(mixed $value, string $default = ''): string {
    if (is_string($value)) {
      return $value;
    }
    if (is_int($value) || is_float($value) || is_bool($value)) {
      return (string) $value;
    }
    if ($value instanceof \Stringable) {
      return (string) $value;
    }
    return $default;
  }

  /**
   * Casts a value to an integer.
   */
  public static function toInt(mixed $value, int $default = 0): int {
    if (is_int($value)) {
      return $value;
    }
    if (is_float($value)) {
      return (int) $value;
    }
    if (is_string($value) && is_numeric($value)) {
      return (int) $value;
    }
    return $default;
  }

  /**
   * Casts a value to an integer or NULL.
   */
  public static function toNullableInt(mixed $value): ?int {
    if ($value === NULL) {
      return NULL;
    }
    return self::toInt($value);
  }

}
