<?php

declare(strict_types=1);

namespace Drupal\nexi_xpay\Value;

use Symfony\Component\HttpFoundation\Response;

/**
 * Result object returned by XPay mode startPayment().
 *
 * A mode can either:
 * - return a Symfony Response (typically a redirect to Nexi/HPP), or
 * - return a Drupal render array to be rendered as an intermediate page.
 *
 * The controller decides how to respond based on which property is populated.
 * This keeps mode plugins simple and allows consistent controller logic.
 */
final readonly class ModeStartResult {

  /**
   * The constructor.
   *
   * @param \Symfony\Component\HttpFoundation\Response|null $response
   *   Optional HTTP response (usually a redirect).
   * @param array<string, mixed>|null $renderArray
   *   Optional Drupal render array to display a page.
   */
  private function __construct(
    public ?Response $response,
    public ?array $renderArray,
  ) {}

  /**
   * The response object.
   */
  public static function response(Response $response): self {
    return new self($response, NULL);
  }

  /**
   * Convenience constructor for render arrays.
   *
   * @param array<string, mixed> $build
   *   A Drupal render array.
   */
  public static function render(array $build): self {
    return new self(NULL, $build);
  }

}
