<?php

declare(strict_types=1);

namespace Drupal\nextgen\Drush\Generators;

use Drupal\Core\StringTranslation\StringTranslationTrait;
use DrupalCodeGenerator\Asset\AssetCollection as Assets;
use DrupalCodeGenerator\Attribute\Generator;
use DrupalCodeGenerator\Command\BaseGenerator;
use DrupalCodeGenerator\GeneratorType;
use DrupalCodeGenerator\Validator\Required;

#[Generator(
  name: 'next-jsonapi-page',
  description: 'Generate Next.js pages from JSON:API pages.',
  templatePath: __DIR__,
  type: GeneratorType::OTHER,
)]

/**
 * Next generator for JSON:API pages.
 */
final class PageJsonApiGenerator extends BaseGenerator {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  protected function generate(array &$vars, Assets $assets): void {
    $ir = $this->createInterviewer($vars);

    $path = $ir->ask('JSON:API Page path', validator: new Required());
    $vars['path'] = trim($path, " /");

    $title = $ir->ask('Page title', validator: new Required());
    $vars['title'] = trim($title);

    // Get class value.
    $vars['class'] = $ir->askClass(default: '{path|camelize}');

    // Create directory and file.
    $vars['next_root'] = $ir->ask('Next.js root directory', default: 'next');

    $dir_path = $vars['next_root'] . '/app/' . $vars['path'];
    $directory = $assets->addDirectory($dir_path)->preserveIfExists();
    if (!$directory) {
      $this->io()->error((string) $this->t('The directory "@dir" did not created.', [
        '@dir' => $dir_path,
      ]));
      return;
    }

    $assets->addFile("$dir_path/page.tsx", 'jsonapi-page.twig');
  }

}
