<?php

declare(strict_types=1);

namespace Drupal\nextgen\Drush\Generators;

use Drupal\Core\StringTranslation\StringTranslationTrait;
use DrupalCodeGenerator\Asset\AssetCollection as Assets;
use DrupalCodeGenerator\Command\BaseGenerator;

/**
 * Base class for Next.js generator.
 */
class NextgenBase extends BaseGenerator {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  protected function generate(array &$vars, Assets $assets): void {
  }

  /**
   * Get Next.js directory.
   *
   * @param array $vars
   *   Variables array.
   * @param string $base_dir
   *   Base directory.
   * @param \DrupalCodeGenerator\Asset\AssetCollection $assets
   *   Assets data.
   *
   * @return string|bool
   *   Directory path or FALSE if the directory creation was failed.
   */
  protected function nextdir(array $vars, string $base_dir, Assets $assets): string|bool {
    $ir = $this->createInterviewer($vars);

    // Create directory and file.
    $next_root = $ir->ask('Next.js root directory', default: 'next');

    $dir_path = $next_root . "/$base_dir/" . $vars['path'];
    $directory = $assets->addDirectory($dir_path)->preserveIfExists();
    if (!$directory) {
      $this->io()->error((string) $this->t('The directory "@dir" did not created.', [
        '@dir' => $dir_path,
      ]));
      return FALSE;
    }

    return $dir_path;
  }

}
