<?php

declare(strict_types=1);

namespace Drupal\nextgen\Drush\Generators;

use DrupalCodeGenerator\Asset\AssetCollection as Assets;
use DrupalCodeGenerator\Attribute\Generator;
use DrupalCodeGenerator\GeneratorType;
use DrupalCodeGenerator\Validator\Required;

#[Generator(
  name: 'next-jsonapi-page',
  description: 'Generate Next.js pages from JSON:API pages.',
  templatePath: __DIR__,
  type: GeneratorType::OTHER,
)]

/**
 * Next generator for JSON:API pages.
 */
final class PageJsonApiGenerator extends NextgenBase {

  /**
   * {@inheritdoc}
   */
  protected function generate(array &$vars, Assets $assets): void {
    $ir = $this->createInterviewer($vars);

    // Get Page path.
    $path = $ir->ask('JSON:API Page path', validator: new Required());
    $vars['path'] = trim($path, " /");

    // Get the Page's title.
    $title = $ir->ask('Page title', validator: new Required());
    $vars['title'] = trim($title);

    // Get class value.
    $vars['class'] = $ir->askClass(default: '{path|camelize}');

    // Create directory and file.
    $dir_path = $this->nextdir($vars, 'app', $assets);
    if ($dir_path) {
      $assets->addFile("$dir_path/page.tsx", 'jsonapi-page.twig');
    }
  }

}
