/**
 * @file
 * Adds functionality for the Nice Image Field widget.
 */

(function ($, Drupal, once) {
  Drupal.behaviors.NiceImageFieldWidget = {
    attach: function (context) {
      // Make sortable elements draggable.
      once('niceImageFieldSortable', 'div.nice-imagefield-sortable', context).forEach((sortableElement) => {
        const $sortable = $(sortableElement);
        $sortable.sortable({
          items: '> div',
          opacity: 0.7,
          placeholder: "ui-sortable-placeholder",
          revert: 100,
          stop: function () {
            updateWeights(sortableElement);
          }
        }).disableSelection();
      });

      // Update the weights of sorted elements.
      function updateWeights(wrapper) {
        const selects = wrapper.querySelectorAll('div.nice-imagefield-weight select');
        selects.forEach((select, index) => {
          const options = select.querySelectorAll('option');
          options.forEach(option => option.removeAttribute('selected'));
          const targetOption = select.querySelector(`option[value = "${index}"]`);
          if (targetOption) {
            targetOption.setAttribute('selected', 'selected');
          }
        });
      }

      // Add flip functionality to cards.
      once('niceImageFieldCard', '.nice-imagefield-card', context).forEach((card) => {
        const $card = $(card);
        $card.flip({
          axis: 'x',
          trigger: 'manual'
        });

        const flipBack = card.querySelector('.flip-back');
        const flipFront = card.querySelector('.flip-front');

        if (flipBack) {
          flipBack.addEventListener('click', (event) => {
            event.preventDefault();
            document.querySelectorAll('.nice-imagefield-card').forEach((otherCard) => {
              $(otherCard).flip(false);
            });
            $card.flip(true);
          });
        }

        if (flipFront) {
          flipFront.addEventListener('click', (event) => {
            event.preventDefault();
            $card.flip(false);
          });
        }
      });
    }
  };
})(jQuery, Drupal, once);
