<?php

namespace Drupal\nice_imagefield_widget\Plugin\Field\FieldWidget;

use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\image\Plugin\Field\FieldWidget\ImageWidget;

/**
 * Plugin implementation of the 'nice_image_widget' widget.
 *
 * @FieldWidget(
 *   id = "nice_image_widget",
 *   label = @Translation("Nice Image Widget"),
 *   field_types = {
 *     "image"
 *   },
 * )
 */
class NiceImageWidget extends ImageWidget {
  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state): array {
    $element = parent::settingsForm($form, $form_state);

    $element['preview_image_style'] = [
      '#title' => $this->t('Grid image style'),
      '#type' => 'select',
      '#options' => image_style_options(FALSE),
      '#required' => TRUE,
      '#default_value' => $this->getSetting('preview_image_style'),
      '#description' => $this->t('The preview image will be shown while editing the content. Recommended use preview image style with dimensions larger than 220x220.'),
      '#weight' => 15,
    ];

    return $element;
  }

  /**
   * Overrides formMultipleElements.
   *
   * \Drupal\file\Plugin\Field\FieldWidget\FileWidget::formMultipleElements().
   *
   * Special handling for draggable multiple widgets and 'add more' button.
   *
   * @param \Drupal\Core\Field\FieldItemListInterface $items
   *   The field values.
   * @param array $form
   *   A nested array form elements comprising the form.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current state of the form.
   *
   * @return array
   *   Returns array of elements.
   */
  protected function formMultipleElements(FieldItemListInterface $items, array &$form, FormStateInterface $form_state): array {
    $elements = parent::formMultipleElements($items, $form, $form_state);
    $elements['#theme'] = 'nice_imagefield_widget_multiple';
    $elements['#attached']['library'][] = 'nice_imagefield_widget/sortable';

    return $elements;
  }

  /**
   * {@inheritdoc}
   */
  public static function isApplicable(FieldDefinitionInterface $field_definition) {
    return $field_definition->getFieldStorageDefinition()->getCardinality() !== 1;
  }

}
