/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./sources/js/builder/modules/code_mirror.js":
/*!***************************************************!*\
  !*** ./sources/js/builder/modules/code_mirror.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   codeMirror: () => (/* binding */ codeMirror)
/* harmony export */ });
function codeMirror() {
  (function ($, Drupal, drupalSettings) {
    initMutationObserver();
    function initMutationObserver() {
      var observer = new MutationObserver(function (mutations) {
        mutations.forEach(function (mutation) {
          mutation.addedNodes.forEach(function (addedNode) {
            if (addedNode.nodeType === 1 && addedNode.classList.contains("noahs_page_builder-modal")) {
              setTimeout(function () {
                customMirror();
              }, 50);
            }
          });
        });
      });
      observer.observe(document.body, {
        childList: true,
        subtree: true
      });
    }
    function customMirror() {
      var textarea = $('.noahs_page_builder_codemirror');
      var widget_id = textarea.closest('form').find('input[name="wid"]').val();
      textarea.each(function () {
        var miTextarea = this;
        var miCodeMirror = CodeMirror.fromTextArea(miTextarea, {
          mode: "css",
          lineNumbers: true,
          theme: "material-darker",
          extraKeys: {
            "Ctrl-Space": "autocomplete"
          }
        });
        if (widget_id) {
          // Detectar cambios en el contenido de CodeMirror
          miCodeMirror.on("change", function (cm) {
            var currentValue = cm.getValue();
            textarea.val(currentValue);
            modificarEstilo(textarea, widget_id);
            modificarJson(textarea, widget_id);
          });
        }
      });
    }
    $(window).on('load', function () {
      setTimeout(function () {
        customMirror();
      }, 50);
    });
  })(jQuery, Drupal, drupalSettings);
}

/***/ }),

/***/ "./sources/js/builder/modules/color.js":
/*!*********************************************!*\
  !*** ./sources/js/builder/modules/color.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   colorSpectrum: () => (/* binding */ colorSpectrum)
/* harmony export */ });
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
(function () {
  var supportsPassive = function () {
    var passive = false;
    try {
      var opts = Object.defineProperty({}, 'passive', {
        get: function get() {
          passive = true;
        }
      });
      window.addEventListener("test", null, opts);
    } catch (e) {}
    return passive;
  }();
  if (supportsPassive) {
    var originalAddEventListener = EventTarget.prototype.addEventListener;
    EventTarget.prototype.addEventListener = function (type, listener, options) {
      if (type === "touchstart" || type === "touchmove") {
        if (_typeof(options) === "object") {
          options.passive = true;
        } else {
          options = {
            passive: true
          };
        }
      }
      originalAddEventListener.call(this, type, listener, options);
    };
  }
})();
function colorSpectrum() {
  (function ($, Drupal, drupalSettings, _drupalSettings$noahs) {
    var palleteColors = (drupalSettings === null || drupalSettings === void 0 || (_drupalSettings$noahs = drupalSettings.noahs_page_builder) === null || _drupalSettings$noahs === void 0 ? void 0 : _drupalSettings$noahs.pallete_color) || [];
    initMutationObserver();
    function initMutationObserver() {
      var observer = new MutationObserver(function (mutations) {
        mutations.forEach(function (mutation) {
          mutation.addedNodes.forEach(function (addedNode) {
            if (addedNode.nodeType === 1 && addedNode.classList.contains("noahs_page_builder-modal")) {
              setTimeout(function () {
                var widget_id = document.querySelector('input[name="wid"]').value;
                initializeColorSpectrum(widget_id);
              }, 50);
            }
          });
        });
      });
      observer.observe(document.body, {
        childList: true,
        subtree: true
      });
    }
    function initializeColorSpectrum(widget_id) {
      $(document).on("touchstart", ".form-control-color", function (event) {
        event.passive = true;
      });
      document.querySelectorAll('.form-control-color').forEach(function (element) {
        if (!element.dataset.colorFieldSpectrum) {
          element.dataset.colorFieldSpectrum = true;
          $(element).spectrum({
            type: "component",
            preferredFormat: "hex",
            showInput: true,
            showInitial: true,
            showAlpha: true,
            hideAfterPaletteSelect: true,
            showPalette: true,
            showSelectionPalette: true,
            palette: palleteColors,
            appendTo: element.parentElement,
            allowEmpty: true,
            localStorageKey: "spectrum.default",
            move: function move(color) {
              // $(element).val(color.toHexString());
              if ($(element).closest('#noahs_page_builder_edit_widget_form').length) {
                modificarEstilo(element, widget_id);
                modificarJson(element, widget_id);
              }
              if ($(element).closest('#noahs_page_builder_sttings_page_form').length) {
                modifyPageStyles();
              }
              if ($(element).closest('#noahs_settings_form').length) {
                modifyNoahsSettingstyles(element);
              }
            }
          });
        }
      });
      document.querySelectorAll('.form-control-color-alpha').forEach(function (element) {
        if (!element.dataset.colorFieldSpectrum) {
          element.dataset.colorFieldSpectrum = true;
          $(element).spectrum({
            type: "component",
            preferredFormat: "hex",
            showInput: true,
            showInitial: true,
            showAlpha: true,
            showPalette: true,
            showSelectionPalette: true,
            palette: palleteColors,
            appendTo: element.parentElement,
            localStorageKey: "spectrum.overlay",
            move: function move(color) {
              // $(element).val(color.toHexString());
              modificarEstilo(element, widget_id);
            }
          });
        }
      });
    }

    // Inicializar colorSpectrum en la carga del DOM
    $(document).ready(function () {
      initializeColorSpectrum();
    });
  })(jQuery, Drupal, drupalSettings);
}

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!****************************************!*\
  !*** ./sources/js/builder/settings.js ***!
  \****************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _modules_code_mirror_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./modules/code_mirror.js */ "./sources/js/builder/modules/code_mirror.js");
/* harmony import */ var _modules_color_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./modules/color.js */ "./sources/js/builder/modules/color.js");


document.addEventListener('DOMContentLoaded', function () {
  (0,_modules_code_mirror_js__WEBPACK_IMPORTED_MODULE_0__.codeMirror)();
  (0,_modules_color_js__WEBPACK_IMPORTED_MODULE_1__.colorSpectrum)();
});
})();

/******/ })()
;
//# sourceMappingURL=settings.js.map