<?php

namespace Drupal\noahs_page_builder;

/**
 * {@inheritdoc}
 */
class Fonts {

  /**
   * Get fonts.
   *
   * @return array
   *   The fonts.
   */
  public static function getFonts(): array {
    $font_options = [
      '' => 'Default',
      'Droid Sans' => 'Droid Sans',
      'Exo 2' => 'Exo 2',
      'Inter' => 'Inter',
      'Jost' => 'Jost',
      'Lato' => 'Lato',
      'Lora' => 'Lora',
      'Merriweather' => 'Merriweather',
      'Montserrat' => 'Montserrat',
      'Noto Sans' => 'Noto Sans',
      'Nunito' => 'Nunito',
      'Open Sans' => 'Open Sans',
      'Oswald' => 'Oswald',
      'Outfit' => 'Outfit',
      'Playfair Display' => 'Playfair Display',
      'Poppins' => 'Poppins',
      'PT Sans' => 'PT Sans',
      'Raleway' => 'Raleway',
      'Roboto' => 'Roboto',
      'Roboto Condensed' => 'Roboto Condensed',
      'Roboto Mono' => 'Roboto Mono',
      'Roboto Slab' => 'Roboto Slab',
      'Sora' => 'Sora',
      'Titillium Web' => 'Titillium Web',
      'Tomorrow' => 'Tomorrow',
      'Ubuntu' => 'Ubuntu',
      'Ubuntu Condensed' => 'Ubuntu Condensed',
      'Work Sans' => 'Work Sans',
    ];

    return $font_options;
  }

  /**
   * Get fonts weights.
   *
   * @return array
   *   The fonts weights.
   */
  public static function getFontsWeights(): array {
    $noahs_page_builder_fonts = [
      ""    => "Default",
      "100" => "100",
      "200" => "200",
      "300" => "300",
      "400" => "400",
      "500" => "500",
      "600" => "600",
      "700" => "700",
      "800" => "800",
      "900" => "900",
      "normal" => "Normal",
      "bold" => "Bold",
    ];
    return $noahs_page_builder_fonts;
  }

}
