<?php

namespace Drupal\noahs_page_builder\Plugin\Widget;

/**
 * @WidgetPlugin(
 *   id = "noahs_plain_text",
 *   label = @Translation("Plain Text")
 * )
 */
class WidgetNoahsPlainText extends WidgetBase {

  /**
   * {@inheritdoc}
   */
  public function data() {
    return [
      'icon' => '<svg height="512pt" viewBox="0 0 512 512" width="512pt" xmlns="http://www.w3.org/2000/svg" id="fi_1891294"><path d="m497.753906 66.054688c7.855469 0 14.246094-6.390626 14.246094-14.246094v-37.5625c0-7.855469-6.390625-14.246094-14.246094-14.246094h-37.5625c-7.855468 0-14.246094 6.390625-14.246094 14.246094v11.226562h-156.917968v-11.226562c0-7.855469-6.390625-14.246094-14.246094-14.246094h-37.5625c-7.855469 0-14.246094 6.390625-14.246094 14.246094v11.226562h-156.917968v-11.226562c0-7.855469-6.390626-14.246094-14.246094-14.246094h-37.5625c-7.855469 0-14.246094 6.390625-14.246094 14.246094v37.5625c0 7.855468 6.390625 14.246094 14.246094 14.246094h11.222656v156.917968h-11.222656c-7.855469 0-14.246094 6.390625-14.246094 14.246094v37.5625c0 7.855469 6.390625 14.246094 14.246094 14.246094h11.222656v156.917968h-11.222656c-7.855469 0-14.246094 6.390626-14.246094 14.246094v37.566406c0 7.851563 6.390625 14.242188 14.246094 14.242188h37.5625c7.855468 0 14.246094-6.390625 14.246094-14.246094v-11.226562h156.917968v11.226562c0 7.855469 6.390625 14.246094 14.246094 14.246094h37.5625c7.855469 0 14.246094-6.390625 14.246094-14.246094v-11.226562h156.917968v11.226562c0 7.855469 6.390626 14.246094 14.246094 14.246094h37.5625c7.855469 0 14.246094-6.390625 14.246094-14.246094v-37.5625c0-7.855468-6.390625-14.246094-14.246094-14.246094h-11.222656v-156.917968h11.222656c7.855469 0 14.246094-6.390625 14.246094-14.246094v-37.5625c0-7.855469-6.390625-14.246094-14.246094-14.246094h-11.222656v-156.917968zm-36.695312-50.941407h35.828125v35.828125h-35.828125zm-222.972656 0h35.828124v35.828125h-35.828124zm-222.972657 35.828125v-35.828125h35.828125v35.828125zm0 222.972656v-35.828124h35.828125v35.828124zm35.828125 222.972657h-35.828125v-35.828125h35.828125zm222.972656 0h-35.828124v-35.828125h35.828124zm222.972657-35.828125v35.828125h-35.828125v-35.828125zm0-187.144532h-35.828125v-35.828124h35.828125zm-25.472657-50.941406h-11.222656c-7.855468 0-14.246094 6.390625-14.246094 14.246094v37.5625c0 7.855469 6.390626 14.246094 14.246094 14.246094h11.222656v156.917968h-11.222656c-7.855468 0-14.246094 6.390626-14.246094 14.246094v11.222656h-156.917968v-11.222656c0-7.855468-6.390625-14.246094-14.246094-14.246094h-37.5625c-7.855469 0-14.246094 6.390626-14.246094 14.246094v11.222656h-156.917968v-11.222656c0-7.855468-6.390626-14.246094-14.242188-14.246094h-11.226562v-156.917968h11.222656c7.855468 0 14.246094-6.390625 14.246094-14.246094v-37.5625c0-7.855469-6.390626-14.246094-14.246094-14.246094h-11.222656v-156.917968h11.222656c7.855468 0 14.246094-6.390626 14.246094-14.246094v-11.222656h156.917968v11.222656c0 7.855468 6.390625 14.246094 14.246094 14.246094h37.5625c7.855469 0 14.246094-6.390626 14.246094-14.246094v-11.222656h156.917968v11.222656c0 7.855468 6.390626 14.246094 14.246094 14.246094h11.222656zm0 0"></path><path d="m382.183594 99.320312h-111.699219c-4.171875 0-7.554687 3.382813-7.554687 7.558594 0 4.171875 3.382812 7.554688 7.554687 7.554688h111.699219c15.808594 0 28.671875 12.863281 28.671875 28.671875v225.789062c0 15.808594-12.863281 28.671875-28.671875 28.671875h-252.367188c-15.808594 0-28.671875-12.863281-28.671875-28.671875v-225.789062c0-15.808594 12.863281-28.671875 28.671875-28.671875h107.171875c4.175781 0 7.558594-3.382813 7.558594-7.554688 0-4.175781-3.382813-7.558594-7.558594-7.558594h-107.171875c-24.144531 0-43.785156 19.640626-43.785156 43.785157v225.789062c0 24.144531 19.640625 43.785157 43.785156 43.785157h252.367188c24.144531 0 43.785156-19.640626 43.785156-43.785157v-225.789062c0-24.144531-19.640625-43.785157-43.785156-43.785157zm0 0"></path><path d="m157.28125 218.519531 2.742188-9.246093h28.144531l2.945312 9.246093c1.285157 3.726563 3.792969 5.589844 7.519531 5.589844 2.234376 0 4.128907-.679687 5.6875-2.035156 1.625-1.554688 2.4375-3.214844 2.4375-4.976563 0-1.761718-.269531-3.386718-.8125-4.875l-19.914062-54.152344c-2.234375-6.097656-6.195312-9.144531-11.886719-9.144531-5.753906 0-9.75 3.046875-11.988281 9.144531l-20.214844 54.046876c-.476562 1.21875-.710937 2.578124-.710937 4.066406 0 2.234375.777343 4.132812 2.335937 5.6875 1.554688 1.558594 3.488282 2.339844 5.792969 2.339844 4.128906 0 6.769531-1.898438 7.921875-5.691407zm16.863281-52.527343 9.042969 28.550781-18.488281-.101563zm0 0"></path><path d="m371.027344 153.902344h-137.480469c-4.175781 0-7.558594 3.382812-7.558594 7.558594 0 4.175781 3.382813 7.558593 7.558594 7.558593h137.480469c4.175781 0 7.558594-3.382812 7.558594-7.558593 0-4.175782-3.382813-7.558594-7.558594-7.558594zm0 0"></path><path d="m371.027344 202.710938h-137.480469c-4.175781 0-7.558594 3.382812-7.558594 7.554687 0 4.175781 3.382813 7.558594 7.558594 7.558594h137.480469c4.175781 0 7.558594-3.382813 7.558594-7.558594 0-4.171875-3.382813-7.554687-7.558594-7.554687zm0 0"></path><path d="m371.027344 251.515625h-225.589844c-4.171875 0-7.554688 3.382813-7.554688 7.558594 0 4.171875 3.382813 7.558593 7.554688 7.558593h225.59375c4.171875 0 7.554688-3.386718 7.554688-7.558593 0-4.175781-3.382813-7.558594-7.558594-7.558594zm0 0"></path><path d="m371.027344 300.324219h-95.304688c-4.175781 0-7.558594 3.382812-7.558594 7.554687 0 4.175782 3.382813 7.558594 7.558594 7.558594h95.304688c4.175781 0 7.558594-3.382812 7.558594-7.558594 0-4.171875-3.382813-7.554687-7.558594-7.554687zm0 0"></path><path d="m145.4375 364.242188h225.59375c4.171875 0 7.554688-3.382813 7.554688-7.554688 0-4.175781-3.382813-7.558594-7.554688-7.558594h-225.59375c-4.171875 0-7.554688 3.382813-7.554688 7.558594 0 4.171875 3.382813 7.554688 7.554688 7.554688zm0 0"></path><path d="m145.4375 315.4375h94.457031c4.171875 0 7.554688-3.382812 7.554688-7.558594 0-4.171875-3.382813-7.554687-7.554688-7.554687h-94.457031c-4.171875 0-7.554688 3.382812-7.554688 7.554687 0 4.175782 3.382813 7.558594 7.554688 7.558594zm0 0"></path></svg>',
      'title' => 'Plain Text',
  'description' => 'Simple text block for paragraphs or notes.',
      'group' => 'General',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildWidgetForm(array $form) {
    

    // Section Content.
    $form['section_content'] = [
      'type' => 'tab',
      'title' => t('Content'),
    ];

    $form['text'] = [
      'type'      => 'textarea',
      'title'     => t('Text'),
      'default_value' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.',
      'tab'     => 'section_content',
      'title'     => ('Text Area'),
      'format' => 'noahs_textarea_plain',
      'update_selector' => '.widget-content',
      'translate' => TRUE,
      'wrapper' => FALSE,
      'translate_ai' => TRUE,
    ];

    $form['section_style'] = [
      'type' => 'tab',
      'title' => t('Style'),
    ];

    $form['font'] = [
      'type'        => 'noahs_font',
      'title'       => t('Font'),
      'tab'     => 'section_style',
      'style_type' => 'style',
      'style_selector' => '.widget-content',
      'responsive' => TRUE,
      'wrapper' => FALSE,
    ];
    $form['text_align'] = [
      'type'    => 'select',
      'title'   => t('Text Align'),
      'tab' => 'section_content',
      'style_type' => 'style',
      'style_selector' => '.widget-content',
      'style_css' => 'text-align',
      'options' => [
        '' => 'Select',
        'left' => 'Left',
        'center' => 'Center',
        'right' => 'Right',
      ],
      'wrapper' => FALSE,
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public static function template($settings) {

    $ouput = '<div class="widget-content">';
    $ouput .= !empty($settings->element->text) ? $settings->element->text : 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.';
    $ouput .= '</div>';
    return $ouput;
  }

  /**
   * {@inheritdoc}
   */
  public function renderContent($element, $content = NULL) {

    return $this->wrapper($element, $this->template($element->settings));
  }

}
