document.addEventListener("DOMContentLoaded", function () {


  function updateHeaderHeight() {
    
    const body = document.body;
    const header = document.querySelector(".noahs-theme--header");
    const headerEmpty = document.querySelector(".noahs-header-empty");
    const toolbar = document.querySelector("#toolbar-administration");
    const gin_toolbar = document.querySelector(".gin-secondary-toolbar--frontend");

    const requiredClasses = ['gin--core-navigation', 'toolbar-horizontal'];
    const ginPresent = requiredClasses.every(cls => body.classList.contains(cls));


    if (header) {
      // Ajustar el top del header si existe el toolbar de administración
      if (toolbar) {
        let toolbarHeight = 79;
        header.style.top = `${toolbarHeight}px`;
      }
      if (gin_toolbar) {
        let toolbarHeight = 50;
        header.style.top = `${toolbarHeight}px`;
      }
      if (ginPresent) {
        const toolbarHorizontal = document.querySelector("#admin-toolbar");
        const toolbarWidth = toolbarHorizontal ? toolbarHorizontal.offsetWidth : 0;
        header.style.width = `calc(100% - ${toolbarWidth}px)`;
      }

      if (headerEmpty) {
        headerEmpty.style.height = `${header.offsetHeight}px`; 
      }
    }
  }

  // Esperar hasta que el header esté en el DOM antes de observarlo
  const checkHeader = setInterval(() => {
    const header = document.querySelector(".noahs-theme--header");
 
    if (header) {
      clearInterval(checkHeader); // Detener el intervalo

      // Ajustar la altura y posición inicialmente
      updateHeaderHeight();

      // Observar cambios en el tamaño del header
      const resizeObserver = new ResizeObserver(updateHeaderHeight);
      resizeObserver.observe(header);

      // También actualizar en caso de cambios en el tamaño de la ventana
      window.addEventListener("resize", updateHeaderHeight);
    }
  }, 100);
});
