/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./sources/js/modules/popupManager.js":
/*!********************************************!*\
  !*** ./sources/js/modules/popupManager.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PopupManager)
/* harmony export */ });
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
// popupManager.js
var PopupManager = /*#__PURE__*/function () {
  function PopupManager(popups) {
    var currentNodeId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    _classCallCheck(this, PopupManager);
    this.popups = popups;
    this.currentNodeId = currentNodeId;
  }

  /**
   * Decide si un popup debe mostrarse según condiciones.
   */
  return _createClass(PopupManager, [{
    key: "shouldShowPopup",
    value: function shouldShowPopup(popup) {
      var popupSetting = JSON.parse(popup.popup_settings);
      var conditions = popupSetting.conditions || [];
      var show = false;
      for (var _i = 0, _Object$values = Object.values(conditions); _i < _Object$values.length; _i++) {
        var condition = _Object$values[_i];
        var action = condition.action,
          type = condition.type;
        if (type === 'entire_site') show = action === 'include';
        if (type === 'single_page' && Array.isArray(condition.pages)) {
          var match = condition.pages.includes(this.currentNodeId);
          if (match && action === 'include') show = true;
          if (match && action === 'exclude') show = false;
        }
        if (type === 'content_type' && Array.isArray(condition.types)) {
          var _drupalSettings;
          var contentType = (_drupalSettings = drupalSettings) === null || _drupalSettings === void 0 || (_drupalSettings = _drupalSettings.node) === null || _drupalSettings === void 0 ? void 0 : _drupalSettings.type;
          var _match = contentType && condition.types.includes(contentType);
          if (_match && action === 'include') show = true;
          if (_match && action === 'exclude') show = false;
        }
      }
      if (!this.canShowPopup(popup)) show = false;
      return show;
    }

    /**
     * Calcula tiempo de expiración en milisegundos.
     */
  }, {
    key: "calculateCloseDelay",
    value: function calculateCloseDelay(close_action) {
      if (!close_action) return 7 * 24 * 60 * 60 * 1000;
      var delay_value = close_action.delay_value,
        delay_unit = close_action.delay_unit;
      var value = parseInt(delay_value, 10) || 7;
      switch (delay_unit) {
        case 'seconds':
          return value * 1000;
        case 'minutes':
          return value * 60 * 1000;
        case 'hours':
          return value * 60 * 60 * 1000;
        case 'days':
          return value * 24 * 60 * 60 * 1000;
        default:
          return 7 * 24 * 60 * 60 * 1000;
      }
    }

    /**
     * Comprueba si el popup puede mostrarse según localStorage.
     */
  }, {
    key: "canShowPopup",
    value: function canShowPopup(popup) {
      var closedUntil = localStorage.getItem("popupClosedUntil_".concat(popup.noahs_id));
      if (closedUntil && Date.now() < parseInt(closedUntil, 10)) return false;
      return true;
    }

    /**
     * Marca popup como cerrado en localStorage.
     */
  }, {
    key: "registerPopupClosed",
    value: function registerPopupClosed(popup) {
      var popupSetting = JSON.parse(popup.popup_settings);
      var delay = this.calculateCloseDelay(popupSetting.close_action);
      var expireAt = Date.now() + delay;
      localStorage.setItem("popupClosedUntil_".concat(popup.noahs_id), expireAt);
    }

    /**
     * Carga el HTML del popup y lo agrega al DOM.
     */
  }, {
    key: "loadPopup",
    value: (function () {
      var _loadPopup = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee(popup) {
        var _this = this;
        var _popupElement$querySe, loader, response, html, wrapper, popupElement;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.prev = 0;
              loader = document.createElement('div');
              loader.classList.add('noahs-popup-loader');
              loader.innerHTML = "<div class=\"spinner-border\" role=\"status\">\n                            <span class=\"visually-hidden\">Loading...</span>\n                          </div>";
              document.body.appendChild(loader);
              _context.next = 7;
              return fetch("/noahs-popup/render/".concat(popup.noahs_id));
            case 7:
              response = _context.sent;
              if (response.ok) {
                _context.next = 10;
                break;
              }
              return _context.abrupt("return");
            case 10:
              _context.next = 12;
              return response.text();
            case 12:
              html = _context.sent;
              wrapper = document.createElement('div');
              wrapper.innerHTML = html;
              popupElement = wrapper.firstElementChild;
              if (popupElement) {
                _context.next = 18;
                break;
              }
              return _context.abrupt("return");
            case 18:
              // Id consistente para poder cerrar desde botones
              popupElement.id = "noahs-popup-".concat(popup.noahs_id);

              // Evento de cerrar
              (_popupElement$querySe = popupElement.querySelector('.noahs_close_popup')) === null || _popupElement$querySe === void 0 || _popupElement$querySe.addEventListener('click', function () {
                popupElement.remove();
                _this.registerPopupClosed(popup);
              });
              loader.remove();
              document.body.appendChild(popupElement);
              _context.next = 27;
              break;
            case 24:
              _context.prev = 24;
              _context.t0 = _context["catch"](0);
              console.error("Error al cargar popup ".concat(popup.noahs_id, ":"), _context.t0);
            case 27:
            case "end":
              return _context.stop();
          }
        }, _callee, null, [[0, 24]]);
      }));
      function loadPopup(_x) {
        return _loadPopup.apply(this, arguments);
      }
      return loadPopup;
    }()
    /**
     * Ejecuta triggers automáticos de los popups.
     */
    )
  }, {
    key: "runTriggers",
    value: function runTriggers() {
      var _this2 = this;
      var _loop = function _loop() {
        var _triggers$on_load, _triggers$on_scroll;
        var popup = _Object$values2[_i2];
        if (!_this2.shouldShowPopup(popup)) return 1; // continue
        var popupSetting = JSON.parse(popup.popup_settings);
        var triggers = popupSetting.triggers || {};

        // On Load
        if (((_triggers$on_load = triggers.on_load) === null || _triggers$on_load === void 0 ? void 0 : _triggers$on_load.enabled) === "true") {
          var delay = parseInt(triggers.on_load.delay || 0, 10) * 1000;
          setTimeout(function () {
            return _this2.loadPopup(popup);
          }, delay);
        }

        // On Scroll
        if (((_triggers$on_scroll = triggers.on_scroll) === null || _triggers$on_scroll === void 0 ? void 0 : _triggers$on_scroll.enabled) === "true") {
          var offset = parseInt(triggers.on_scroll.offset || 0, 10);
          var _handler = function handler() {
            if (window.scrollY >= offset) {
              _this2.loadPopup(popup);
              window.removeEventListener('scroll', _handler);
            }
          };
          window.addEventListener('scroll', _handler);
        }
      };
      for (var _i2 = 0, _Object$values2 = Object.values(this.popups); _i2 < _Object$values2.length; _i2++) {
        if (_loop()) continue;
      }
    }

    /**
     * Maneja los botones que abren o cierran popups manualmente.
     */
  }, {
    key: "runButtons",
    value: function runButtons() {
      var _this3 = this;
      document.addEventListener('click', function (e) {
        var btn = e.target.closest('[data-popup-action]');
        if (!btn) return;
        e.preventDefault();
        var action = btn.dataset.popupAction; // "open_popup" | "close_popup"
        var popupId = btn.dataset.popupSettings;
        console.log("Button clicked: ".concat(action, ", Popup ID: ").concat(popupId));
        if (!popupId) return;
        var popup = _this3.popups[popupId];
        console.log(popup);
        if (!popup) return;
        if (action === 'open_popup') {
          _this3.loadPopup(popup); // ignorando triggers y condiciones
        }
        if (action === 'close_popup') {
          var el = document.querySelector("#noahs-popup-".concat(popupId));
          if (el) el.remove();
          _this3.registerPopupClosed(popup);
        }
      });
    }

    /**
     * Inicializa todo: triggers y botones manuales.
     */
  }, {
    key: "init",
    value: function init() {
      this.runTriggers();
      this.runButtons();
    }
  }]);
}();


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!***************************!*\
  !*** ./sources/js/app.js ***!
  \***************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _modules_popupManager_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./modules/popupManager.js */ "./sources/js/modules/popupManager.js");

(function (Drupal, drupalSettings) {
  Drupal.behaviors.noahsPopupLoader = {
    attach: function attach(context, settings) {
      var _drupalSettings$noahs, _drupalSettings$noahs2, _drupalSettings$noahs3;
      var popups = ((_drupalSettings$noahs = drupalSettings.noahs_popups) === null || _drupalSettings$noahs === void 0 ? void 0 : _drupalSettings$noahs.popups) || [];
      var currentNodeId = (_drupalSettings$noahs2 = (_drupalSettings$noahs3 = drupalSettings.noahs_popups) === null || _drupalSettings$noahs3 === void 0 || (_drupalSettings$noahs3 = _drupalSettings$noahs3.nid) === null || _drupalSettings$noahs3 === void 0 ? void 0 : _drupalSettings$noahs3.toString()) !== null && _drupalSettings$noahs2 !== void 0 ? _drupalSettings$noahs2 : null;
      var manager = new _modules_popupManager_js__WEBPACK_IMPORTED_MODULE_0__["default"](popups, currentNodeId);
      manager.init();
    }
  };
})(Drupal, drupalSettings);
})();

/******/ })()
;
//# sourceMappingURL=app.js.map