<?php

namespace Drupal\noahs_popups\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Drupal\Core\Database\Database;

class NoahsPopupCreateForm extends FormBase {

  public function getFormId() {
    return 'noahs_page_builder_popup_create_form';
  }

  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['name'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Nombre del popup'),
      '#required' => TRUE,
    ];

    $form['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Añadir'),
    ];

    return $form;
  }

  public function submitForm(array &$form, FormStateInterface $form_state) {
    $name = $form_state->getValue('name');

    $id = uniqid();
    $connection = Database::getConnection();
    $connection->insert('noahs_page_builder_popups')
      ->fields([
        'name' => $name,
        'noahs_id' => $id,
        'langcode' => \Drupal::languageManager()->getCurrentLanguage()->getId(),
      ])
      ->execute();

    $url = Url::fromRoute('noahs_popups.build', [
      'noahs_editor' => 'popup-builder',
      'type' => $id,
    ]);

    $form_state->setRedirectUrl($url);
  }
}
