<?php

namespace Drupal\noahs_popups\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Url;
use Drupal\Core\Link;
use Drupal\Core\Database\Database;

class NoahsPopupListController extends ControllerBase {

  public function list() {
    $header = [
      'name' => $this->t('Name'),
      'Language' => $this->t('Language'),
      'operations' => $this->t('Operations'),
    ];

    $rows = [];
    $connection = Database::getConnection();
    $results = $connection->select('noahs_page_builder_popups', 'p')
      ->fields('p', ['name', 'noahs_id', 'langcode'])
      ->execute();

    foreach ($results as $record) {
      $native_language = \Drupal::languageManager()->getNativeLanguages()[$record->langcode] ?? false;
      $edit_url = Url::fromRoute('noahs_popups.build', [
        'noahs_editor' => 'popup-builder',
        'type' => $record->noahs_id
      ]);

      $rows[] = [
        'data' => [
          ['data' => $record->name],
          ['data' => ($native_language) ? $native_language->getName() : 'Unknown'],
          [
            'data' => Link::fromTextAndUrl($this->t('Editar'), $edit_url)->toRenderable(),
            'class' => ['operations'],
          ],
        ],
      ];
    }

    $build = [];

    // Botón de añadir popup
    $add_url = Url::fromRoute('noahs_popups.create');
    $build['add'] = [
      '#type' => 'link',
      '#title' => $this->t('➕ Añadir nuevo popup'),
      '#url' => $add_url,
      '#attributes' => [
        'class' => ['button', 'button--primary'],
        'style' => 'margin-bottom: 20px; display: inline-block;',
      ],
    ];

    // Tabla
    $build['table'] = [
      '#type' => 'table',
      '#header' => $header,
      '#rows' => $rows,
      '#empty' => $this->t('No hay popups creados aún.'),
    ];

    return $build;
  }
}
