<?php

namespace Drupal\noahs_popups\Plugin\Control;
use Drupal\noahs_page_builder\Plugin\Control\ControlBase;
use Drupal\noahs_page_builder\Annotation\ControlPlugin;

/**
 * @ControlPlugin(
 *   id = "actions",
 *   label = @Translation("Popups Actions"),
 * )
 */

class ControlNoahsActions extends ControlBase {

  /**
   * {@inheritdoc}
   */
  public function getype() {
    return 'actions';
  }

  /**
   * {@inheritdoc}
   */
  public function contentTemplate(array $params = []) {

    $data = $params['data'] ?? NULL;
    $name = $params['name'] ?? NULL;
    $value = $params['value'] ?? NULL;

    $output = '<div class="form-group mb-2">';
    $output .= '<label>' . t('Action') . '</label>';
    $output .= '<select name="' . $name . '[popup_action]" class="form-select">';
    $output .= '<option value="">'.t('Select value').'</option>';  
    $output .= '<option value="open_popup" ' . (!empty($value['popup_action']) && $value['popup_action'] === 'open_popup' ? 'selected' : '') . '>'.t('Open popup').'</option>';  
    $output .= '<option value="close_popup" ' . (!empty($value['popup_action']) && $value['popup_action'] === 'close_popup' ? 'selected' : '') . '>'.t('Close popup').'</option>';  
    $output .= '<option value="toogle_popup" ' . (!empty($value['popup_action']) && $value['popup_action'] === 'toogle_popup' ? 'selected' : '') . '>'.t('Toogle popup').'</option>';  
    $output .= '</select>';
    $output .= '</div>';

    $output .= '<div class="form-group">';
    $output .= '<label>' . t('Select your popup') . '</label>';
    $output .= '<select name="' . $name . '[popup_select]" class="form-select">';
    $output .= '<option value="">-- Select a popup --</option>';
    
    $results = \Drupal::database()
      ->select('noahs_page_builder_popups', 'n')
      ->fields('n', ['noahs_id', 'name'])
      ->orderBy('name')
      ->execute();
    
    foreach ($results as $row) {
      $output .= '<option value="' . htmlspecialchars($row->noahs_id) . '" ' . (!empty($value['popup_select']) && $value['popup_select'] === $row->noahs_id ? 'selected' : '') . '>' . htmlspecialchars($row->name) . '</option>';
    }
    
    $output .= '</select>';
    $output .= '</div>';
    return $output;
  }

  /**
   * {@inheritdoc}
   */
  public function getDefaultSettings() {
    return [
      'input_type' => 'noahs_actions',
      'placeholder' => '',
      'title' => '',
    ];
  }

}
