<?php

namespace Drupal\noahs_popups\Form;

use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Drupal\Core\Database\Database;

class NoahsPopupDeleteForm extends ConfirmFormBase {

  protected string $noahsId;

  public function getFormId() {
    return 'noahs_popups_delete_form';
  }

  public function getQuestion() {
    return $this->t('Are you sure you want to delete this popup?');
  }

  public function getCancelUrl() {
    return Url::fromRoute('noahs_popups.popup_list');
  }

  public function buildForm(array $form, FormStateInterface $form_state, $noahs_id = NULL) {
    $this->noahsId = $noahs_id;
    return parent::buildForm($form, $form_state);
  }

  public function submitForm(array &$form, FormStateInterface $form_state) {
    $connection = Database::getConnection();
    $connection->delete('noahs_page_builder_popups')
      ->condition('noahs_id', $this->noahsId)
      ->execute();
    $this->messenger()->addStatus($this->t('Popup deleted.'));
    $form_state->setRedirect('noahs_popups.popup_list');
  }
}
