<?php

namespace Drupal\node_authlink;

use Drupal\Core\Config\Config;
use Drupal\Core\Config\ImmutableConfig;

/**
 * Class with helper methods for the module.
 */
class ConfigurationHelper {

  /**
   * Tells if a bundle  is enabled in a node_authlink.settings array.
   *
   * @param \Drupal\Core\Config\Config|\Drupal\Core\Config\ImmutableConfig $config
   *   node_authlink.settings array like the ones Drupal configuration system returns.
   * @param string $bundle
   *   Bundle machine name.
   *
   * @return bool
   *   TRUE if enabled, FALSE if not.
   */
  public static function isBundleEnabled(Config|ImmutableConfig $config, $bundle) {
    return !empty($config->get('enable')[$bundle]);
  }

  /**
   * Returns the grants of a bundle defined in a node_authlink.settings array.
   *
   * @param \Drupal\Core\Config\Config|\Drupal\Core\Config\ImmutableConfig $config
   *   node_authlink.settings array like the ones Drupal configuration system returns.
   * @param string $bundle
   *   Bundle machine name.
   *
   * @return array
   *   Array of grants. Each key is the machine name of the operation, and the
   *   value is either the same operation machine name, meaning is is enabled,
   *   or zero, meaning that operation is not enabled in that bundle for the
   *   given configuration.
   */
  public static function getBundleGrants(Config|ImmutableConfig $config, $bundle) {
    return $config->get('grants')[$bundle];
  }

}
