# Node Form Overrides

Drupal module to override the default node create, update, and delete form titles and button labels.

Often times when building a Drupal site I find myself using `hook_form_alter` to change the page titles and button labels based on certain conditions for that content type. This module aims to make that easier by putting some of these common overrides in the config of the content type.

Currently this only supports node forms, but I may expand it to support other entities in the future.

Suggestions and patches welcome.

- [Project page](https://www.drupal.org/project/node_form_overrides)
- [Issue queue](https://www.drupal.org/project/issues/node_form_overrides)

## Requirements

- node module (required)
- token module (optional)

## Installation

Install the Node Form Overrides module as you would normally install a contributed Drupal module. 
`composer require drupal/node_form_overrides` and `drush en node_form_overrides`

## Configuration

1. Navigate to Administration > Content Types and click the content type you want override, edit the fields under the "Label Overrides" tab and save your changes.

## Maintainers

- [loze](https://www.drupal.org/u/loze)
