<?php

declare(strict_types=1);

namespace Drupal\Tests\node_form_overrides\Functional;

use Drupal\Tests\BrowserTestBase;
use Drupal\node\Entity\NodeType;

/**
 * Base class for Node Form Overrides functional tests.
 */
abstract class NodeFormOverridesTestBase extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'node',
    'node_form_overrides',
  ];

  /**
   * A user with permission to create and edit content.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $adminUser;

  /**
   * The node type used for testing.
   *
   * @var \Drupal\node\NodeTypeInterface
   */
  protected $nodeType;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    // Create a content type.
    $this->nodeType = NodeType::create([
      'type' => 'test_content',
      'name' => 'Test Content',
    ]);
    $this->nodeType->save();

    // Create a user with necessary permissions.
    $this->adminUser = $this->drupalCreateUser([
      'administer content types',
      'administer nodes',
      'create test_content content',
      'edit any test_content content',
      'delete any test_content content',
    ]);
  }

  /**
   * Sets the override settings on the node type.
   *
   * @param array $settings
   *   An array of settings keyed by setting name.
   */
  protected function setOverrideSettings(array $settings): void {
    foreach ($settings as $key => $value) {
      $this->nodeType->setThirdPartySetting('node_form_overrides', $key, $value);
    }
    $this->nodeType->save();
  }

}
