# Node Health

Node Health is a Drupal module that provides reports and tools to monitor the health and storage usage of your site's content types, fields, and node revisions. It helps site administrators identify large tables, track database growth, and manage node revisions efficiently.

## Features

- Reports on content types, field storage, and revision counts.
- Table size and row count tracking for node and revision tables.
- Historical tracking of table sizes (via cron).
- Visualization of table growth over time (charts).
- Batch operations to clean up old node revisions.
- Detailed revision and field usage reports.

## Installation

1. Enable the module via Drupal Admin or Drush:
   ```
   drush en node_health -y
   ```

## Usage

- Access the Node Health reports from the Drupal administration menu:
  - **Node Health Report:** `/admin/reports/node-health`
  - **Revision Report:** `/admin/reports/node-health/revisions`
  - **Table Size Charts:** `/admin/reports/node-health/charts`
- Use the provided filters to refine reports by content type, node ID, title, or revision count.
- Use the batch cleanup tool to remove old node revisions and reduce database size.

## Cron & Data Collection

- Node Health collects table size and row count data during cron runs.
- Ensure your site's cron is running regularly to keep reports up to date.

## Permissions

- Only users with appropriate administrative permissions can access Node Health reports and tools.

## Requirements

- Drupal 10 or higher.
- Database user must have access to `information_schema` (for MySQL) to collect table size data.

## Notes

- The module creates and uses the tables `node_health_sizes` and `node_health_table_names` to store historical data.
- For best results, run cron regularly and monitor the reports for large or growing tables.

## Support

For issues, suggestions, or contributions, please use the project's issue queue on Drupal.org.
