<?php

namespace Drupal\node_health\Controller;

use Drupal\Core\Controller\ControllerBase;

/**
 * Controller for displaying node health charts.
 */
class NodeHealthChartController extends ControllerBase {

  /**
   * Show all tables.
   */
  public function chart() {
    // Simulated data - replace with real DB query.
    $query = \Drupal::database()->select('node_health_sizes', 's');
    $query->innerJoin('node_health_table_names', 't', 's.table_id = t.id');
    $query->fields('s', ['size', 'timestamp', 'count']);
    $query->fields('t', ['table_name']);
    $query->orderBy('s.timestamp', 'DESC');

    $data = $query->execute()->fetchAll();

    $prepared_data = [];
    foreach ($data as $record) {
      $prepared_data[] = [
        'table_name' => $record->table_name,
        'size' => (int) $record->size,
        'count' => (int) $record->count,
        'timestamp' => (int) $record->timestamp,
      ];
    }

    // Sort by 'size' in descending order.
    usort($prepared_data, function ($a, $b) {
      return $b['size'] <=> $a['size'];
    });

    // dd($prepared_data);
    return [
      '#theme' => 'node_health_table_size_chart',
      '#chart_data' => json_encode(array_values($prepared_data)),
      '#table_name' => 'All',
      '#attached' => [
        'drupalSettings' => [
          'node_health' => [
            'chart_data' => array_values($prepared_data),
          ],
        ],
        'library' => [
          'node_health/node_health.chart',
        ],
      ],
    ];
  }

  /**
   * Run for specific table.
   */
  public function table($table) {
    // Simulated data - replace with real DB query.
    $query = \Drupal::database()->select('node_health_sizes', 's');
    $query->innerJoin('node_health_table_names', 't', 's.table_id = t.id');
    $query->fields('s', ['size', 'timestamp', 'count']);
    $query->fields('t', ['table_name']);
    $query->orderBy('s.timestamp', 'DESC');
    $query->condition('t.table_name', $table);

    $data = $query->execute()
      ->fetchAll();

    $prepared_data = [];
    foreach ($data as $record) {
      $prepared_data[] = [
        'table_name' => $record->table_name,
        'size' => (int) $record->size,
        'count' => (int) $record->count,
        'timestamp' => (int) $record->timestamp,
      ];
    }

    return [
      '#theme' => 'node_health_table_size_chart',
      '#chart_data' => json_encode(array_values($prepared_data)),
      '#table_name' => $table,
      '#attached' => [
        'drupalSettings' => [
          'node_health' => [
            'chart_data' => array_values($prepared_data),
          ],
        ],
        'library' => [
          'node_health/node_health.chart',
        ],
      ],
    ];
  }

}
