<?php

namespace Drupal\node_health\Helper;

/**
 * Class NodeHealthFormatSize.
 */
final class NodeHealthFormatSize {

  /**
   * Formats size in bytes to human-readable format.
   */
  public static function formatSize($bytes, $precision = 2) {
    $units = ['B', 'KB', 'MB', 'GB', 'TB'];

    if ($bytes == 0) {
      return '0 B';
    }

    $pow = floor(log($bytes, 1024));
    $pow = min($pow, count($units) - 1);

    $bytes /= pow(1024, $pow);

    return round($bytes, $precision) . ' ' . $units[$pow];
  }

}
