(function ($, Drupal) {
  'use strict';

  Drupal.behaviors.nodeHealthForm = {
    attach(context, settings) {
      const $context = $(context);

      const $checkboxes = $context.find('.drop-table-checkbox');

      console.log($checkboxes)
      once('node-health-orphan-r-tables-select-all', '.node-health-orphan-r-tables-select-all', context).forEach((el) => {
        $(el).on('click', () => {
          $checkboxes.prop('checked', true);
        });
      });

      once('node-health-orphan-r-tables-clear-all', '.node-health-orphan-r-tables-clear-all', context).forEach((el) => {
        $(el).on('click', () => {
          $checkboxes.prop('checked', false);
        });
      });

      once('node-health-orphan-r-tables-toggle', '.node-health-orphan-r-tables-toggle', context).forEach((el) => {
        $(el).on('click', () => {
          $checkboxes.each(function () {
            $(this).prop('checked', !$(this).prop('checked'));
          });
        });
      });



      const $filterInput = $(context).find('.node-health-r-tables-filter');

      $filterInput.on('input', function () {
        const search = $(this).val().toLowerCase();
        $checkboxes.each(function () {
          const $checkbox = $(this);
          const labelText = $checkbox.attr('table-name').toLowerCase();

          if (labelText.includes(search)) {
            $checkbox.closest('tr').show();
          } else {
            $checkbox.closest('tr').hide();
          }
        });
      });


    }
  }

})(jQuery, Drupal);
