(function ($, Drupal, once) {
  Drupal.behaviors.optimizeForm = {
    attach: function (context, settings) {
      const checkboxes = $(context).find('input[type="checkbox"][name^="tables["]');

      once('node-health-optimize-select-all', '.node-health-optimize-select-all', context).forEach((el) => {
        $(el).on('click', () => {
          checkboxes.prop('checked', true);
        });
      });

      once('node-health-optimize-clear-all', '.node-health-optimize-clear-all', context).forEach((el) => {
        $(el).on('click', () => {
          checkboxes.prop('checked', false);
        });
      });

      once('node-health-optimize-toggle', '.node-health-optimize-toggle', context).forEach((el) => {
        $(el).on('click', () => {
          checkboxes.each(function () {
            $(this).prop('checked', !$(this).prop('checked'));
          });
        });
      });


      const $filterInput = $(context).find('.node-health-optimize-filter');

      $filterInput.on('input', function () {
        const search = $(this).val().toLowerCase();

        checkboxes.each(function () {
          const $checkbox = $(this);
          const labelText = $checkbox.parent().find('label').text().toLowerCase();

          if (labelText.includes(search)) {
            $checkbox.parent().show();
          } else {
            $checkbox.parent().hide();
          }
        });
      });

    }
  };
})(jQuery, Drupal, once);
