document.getElementById('node-health-export').addEventListener('click', function () {
  const tables = document.querySelectorAll('table.node-health-size-tables');
  const workbook = XLSX.utils.book_new();
  const summaryData = [];

  tables.forEach((table, index) => {
    const tableId =  `Table${index + 1}`;

    const worksheet = XLSX.utils.table_to_sheet(table);
    XLSX.utils.book_append_sheet(workbook, worksheet, tableId);

    // Collect summary info
    const rows = table.querySelectorAll('tbody tr');
    let totalRows = 0;
    let totalSize = 0;
    let totalRevisionRows = 0;
    let totalRevisionSize = 0;

    rows.forEach(row => {
      const cells = row.querySelectorAll('td');
      const rowCount = parseInt(cells[1]?.innerText || 0);
      const size = parseFloat(cells[2]?.innerText || 0);
      const revRows = parseInt(cells[3]?.innerText || 0);
      const revSize = parseFloat(cells[4]?.innerText || 0);

      totalRows += rowCount;
      totalSize += size;
      totalRevisionRows += revRows;
      totalRevisionSize += revSize;
    });

    summaryData.push({
      Table: tableId,
      Total_Rows: totalRows,
      Total_Size: totalSize,
      Total_Revision_Rows: totalRevisionRows,
      Total_Revision_Size: totalRevisionSize,
    });
  });

  // Create summary worksheet
  const summarySheet = XLSX.utils.json_to_sheet(summaryData);
  XLSX.utils.book_append_sheet(workbook, summarySheet, 'Summary');

  // Download workbook
  const now = new Date();
  const formattedDate = now.toISOString().slice(0, 10); // Format: YYYY-MM-DD
  const fileName = `node-health-report-${formattedDate}.xlsx`;

  XLSX.writeFile(workbook, fileName);

});