<?php

namespace Drupal\node_health\Commands;

use Drush\Commands\DrushCommands;

/**
 * Provides a Drush command to run node_health_cron.
 */
class NodeHealthCronCommands extends DrushCommands {

  /**
   * Runs the node_health_cron hook.
   *
   * @command node-health:run-cron
   * @aliases nrh:cron
   */
  public function runCron(array $options = ['force' => FALSE]) {
    $force = $options['force'] ?? FALSE;
    $this->output()->writeln('▶️ Running node_health_cron...');

    // Execute the hook_cron for the module.
    \Drupal::moduleHandler()->invoke('node_health', 'cron', [$force]);

    $this->output()->writeln('✅ node_health_cron completed.');
  }

}
