<?php

namespace Drupal\node_health\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

/**
 * Form for node health settings.
 */
class NodeHealthSettingsForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'node_health_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {

    $form['container'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Node Health Settings'),
    ];
    $form['container']['cron_notice'] = [
      '#type' => 'markup',
      '#markup' => t('<div class="messages messages--warning"><strong>Important:</strong> The execution of this job depends on Drupal\'s cron system. Make sure that <strong>Drupal cron is running frequently enough</strong> (e.g., via Drush or external cron) to ensure this task runs as scheduled. You can configure it at <a href=":url">Cron settings</a>.</div>', [
        ':url' => Url::fromRoute('system.cron_settings')->toString(),
      ]),
    ];
    $intervals = [
      300 => 'Every 5 minutes',
      600 => 'Every 10 minutes',
      900 => 'Every 15 minutes',
      1800 => 'Every 30 minutes',
      3600 => '1 hour',
      10800 => '3 hours',
      21600 => '6 hours',
      43200 => '12 hours',
      86400 => '1 day',
      604800 => '1 week',
      1209600 => '2 weeks',
      2592000 => '1 month',
    ];

    $config = \Drupal::configFactory()->getEditable('node_health.settings');

    $form['container']['interval'] = [
      '#type' => 'select',
      '#title' => $this->t('Cron Interval'),
      '#description' => $this->t('This module collects information from the database at the interval you select above.'),
      '#options' => $intervals,
      '#default_value' => $config->get('interval') ?: 43200,
    ];

    $form['container']['submit'] = [
      '#type' => 'submit',
      '#attributes' => [
        'style' => 'margin:0',
      ],
      '#value' => $this->t('Save'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $config = \Drupal::configFactory()->getEditable('node_health.settings');
    $config->set('interval', $form_state->getValue('interval'))
      ->save();
    \Drupal::messenger()->addMessage($this->t('Settings saved.'));
  }

}
