The **Node ID Class** module for Drupal enables site builders
to assign custom CSS IDs and classes to the `<body>` element
and individual node wrappers. These can include dynamic tokens
such as `{node_id}`, `{node_title}`, `{bundle}`, and
`{node_author_uid}`, allowing flexible theming, unique layouts,
or custom frontend behavior.

Table of Contents
-----------------

*   [Requirements](#requirements)
*   [Installation](#installation)
*   [Configuration](#configuration)
*   [Dynamic Tokens](#dynamic-tokens)
*   [Troubleshooting & FAQ](#troubleshooting-faq)
*   [Maintainers](#maintainers)

Requirements
------------

*   Drupal 10 or higher
*   No additional contributed modules are required

Installation
------------

1.  Download the **Node ID Class** module.
2.  Install using Composer or the Drupal admin interface.

**Using Composer:**

    composer require drupal/node_id_class

**Manual installation:**  
Download the module and place it in your `modules/custom` directory. See the [Drupal module installation guide](https://www.drupal.org/docs/8/extending-drupal-8/installing-modules) for details.

**Enable the module:**

*   Via the _Extend_ page in the Drupal admin interface
*   Or using Drush:
    
        drush en node_id_class
    

Configuration
-------------

After enabling the module, a new **Node ID Class** fieldset
will appear on each content type’s edit page. For example:

    admin/structure/types/manage/article

Within this fieldset, you can configure the following fields:

**CSS Body ID**

Applied to the `<body>` element on full node pages. Supports
tokens: `{node_id}`, `{bundle}`, `{node_title}`,
`{node_author_uid}`. Validated to ensure no spaces or invalid characters.

Eg. `body-id-{node_id}-{bundle}-{node_title}`, `node--{node_author_uid}`

**CSS Body Class(es)**

Applied to the `<body>` element on full node pages. Supports the
same tokens as above. Allows multiple classes separated by spaces.

Eg. `body-class-{node_id}-{bundle}`, `node--{node_author_uid}`

**CSS Node Class(es)**

Applied to the node wrapper in all view modes and listings
(e.g., Views). Supports the same tokens. Allows multiple
classes separated by spaces.

Eg. `node-class-{node_id}-{bundle}-{node_title}`, `node--{node_author_uid}`

Dynamic Tokens
--------------

The following tokens can be used in IDs and classes:

*   `{node_id}` – Node ID
*   `{node_title}` – Node title (converted to a URL-friendly slug)
*   `{bundle}` – Content type machine name
*   `{node_author_uid}` – Node author’s user ID

Tokens are sanitized and escaped automatically to prevent invalid
markup or XSS vulnerabilities.

Troubleshooting & FAQ
---------------------

*   **Custom classes not appearing?** Ensure the node is displayed
in a full-page view mode and your theme prints `$attributes` and
`$content_attributes`.
*   **Body ID or classes not showing?** Verify that the settings
are saved for the correct content type.
*   **Tokens are not replaced?** Tokens only work when viewing a node page.
*   **Why is HTML not allowed in the fields?** HTML is stripped
for security, preventing XSS attacks and invalid CSS.

Maintainers
-----------

Maintained by Sujan Shrestha — [sujan-shrestha](https://www.drupal.org/u/sujan-shrestha)
