/**
 * @file
 * Show summaries of selected options within tabs.
 */

(function ($) {
  Drupal.behaviors.nodeTypeClass = {
    attach(context) {
      // Display save draft settings summary on the node options fieldset.
      $('#edit-node-id-class-fieldset', context).drupalSetSummary(
        function (context) {
          const vals = [];
          const bodyId = document.getElementById('edit-body-id');
          if (bodyId && bodyId.value !== '') {
            vals.push(Drupal.checkPlain(bodyId.value));
          }

          const bodyClass = document.getElementById('edit-body-class');
          if (bodyClass && bodyClass.value !== '') {
            vals.push(Drupal.checkPlain(bodyClass.value));
          }

          const nodeClass = document.getElementById('edit-node-class');
          if (nodeClass && nodeClass.value !== '') {
            vals.push(Drupal.checkPlain(nodeClass.value));
          }

          if (vals.length > 0) {
            return vals.join(', ');
          }
        },
      );
    },
  };
})(jQuery);
