<?php

declare(strict_types=1);

namespace Drupal\node_revision_delete_protection\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;

/**
 * Listens to the dynamic route events.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection): void {
    // Alter the entity.node.version_history route to use our custom controller.
    if ($route = $collection->get('entity.node.version_history')) {
      $route->setDefault('_controller', '\Drupal\node_revision_delete_protection\Controller\NodeRevisionOverviewController::revisionOverview');
    }
  }

}
