<?php

namespace Drupal\node_role_variants\Access;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Routing\Access\AccessInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\node\NodeInterface;

/**
 * Access check for node role variants tab.
 */
class NodeRoleVariantsAccessCheck implements AccessInterface {

  /**
   * Checks access for the role variants tab.
   *
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The currently logged in account.
   * @param \Drupal\node\NodeInterface|null $node
   *   The node being viewed.
   *
   * @return \Drupal\Core\Access\AccessResultInterface
   *   The access result.
   */
  public function access(AccountInterface $account, NodeInterface $node = NULL) {
    if (!$node) {
      return AccessResult::forbidden();
    }

    // Check if the user has permission.
    $has_permission = $account->hasPermission('administer node role variants');
    if (!$has_permission) {
      return AccessResult::forbidden()->cachePerPermissions();
    }

    // Check if role variants are enabled for this content type.
    $enabled = node_role_variants_is_enabled($node->bundle());

    return AccessResult::allowedIf($enabled)
      ->addCacheableDependency($node->type->entity)
      ->cachePerPermissions();
  }

}
