# NodeHive Content Browser

Provides a quick content finder toolbar item for instant content search in Drupal.

## Features

- **Content Finder** toolbar item for quick access
- Instant search with real-time results
- Keyboard navigation (arrow keys, Enter to view, Ctrl+Enter to edit)
- Global keyboard shortcut (Command+Shift+F on Mac, Ctrl+Shift+F on Windows/Linux)
- Displays content type, published status, and space references
- **Create content directly** when no results are found
- Shows available content types based on user permissions
- Respects Drupal's node access permissions
- Gin theme compatible styling
- Mobile responsive

## Installation

1. Enable the module: `drush en nodehive_content_browser`
2. Grant "Use content finder" permission to appropriate roles
3. Clear cache if the toolbar item doesn't appear

## Usage

### Opening Content Finder
- Click the "Content Finder" icon in the toolbar
- Press Command+Shift+F (Mac) or Ctrl+Shift+F (Windows/Linux)

### Searching
- Type to search content by title
- Results appear instantly as you type

### Navigation
- Use arrow keys (↑↓) to navigate results
- Press Enter to view content
- Press Ctrl+Enter (Cmd+Enter on Mac) to edit content
- Press Escape to close

### Result Display
Each result shows:
- Content type (e.g., [Article], [Page])
- Title
- Published/Unpublished status
- Space references (if applicable)
- Last modified time

### Content Creation
When no search results are found:
- Displays available content types the user can create
- Shows content type name and description
- Click to navigate directly to the create form
- Only shows content types based on user permissions

## Permissions

- **Use content finder**: Allows access to the Content Finder toolbar item

## API Endpoints

### Search Endpoint
`GET /nodehive/content-browser/search`

Parameters:
- `q` (string): Search query
- `limit` (int): Number of results (default: 20)
- `offset` (int): Pagination offset (default: 0)

Returns JSON with search results.

### Content Types Endpoint
`GET /nodehive/content-browser/content-types`

Returns JSON with available content types the user can create, including:
- `id`: Machine name
- `label`: Human-readable name
- `description`: Content type description
- `create_url`: URL to create new content of this type

## Theming

The module is designed to work with the Gin admin theme and uses CSS custom properties for theming. Override these in your theme:

```css
:root {
  --gin-bg-layer: #fff;
  --gin-color-primary: #0074bd;
  --gin-border-color: #dee2e6;
  /* etc. */
}
```

## Extending

The search service can be overridden or extended by decorating the `nodehive_content_browser.search` service.