# NodeHive MCP Module

This module provides Model Context Protocol (MCP) tools for managing NodeHive Spaces.

## Features

The NodeHive MCP module exposes the following tools to MCP clients:

### 1. Create NodeHive Space (`create-nodehive-space`)
Creates a new NodeHive Space with specified properties.

**Parameters:**
- `label` (required): The name/label of the space
- `space_url` (required): The URL for the space
- `space_type` (optional): Type of space (full_website, directory, database, other)
- `status` (optional): Whether the space is enabled (default: true)
- `tags` (optional): Array of tags for the space

### 2. Update NodeHive Space (`update-nodehive-space`)
Updates an existing NodeHive Space.

**Parameters:**
- `space_id` (required): The ID of the space to update
- `label` (optional): The name/label of the space
- `space_url` (optional): The URL for the space
- `space_type` (optional): Type of space (full_website, directory, database, other)
- `status` (optional): Whether the space is enabled
- `tags` (optional): Array of tags for the space

### 3. List NodeHive Spaces (`list-nodehive-spaces`)
Lists all NodeHive Spaces with their details.

**Parameters:**
- `limit` (optional): Maximum number of spaces to return
- `offset` (optional): Number of spaces to skip (default: 0)
- `space_type` (optional): Filter by space type
- `status` (optional): Filter by enabled/disabled status

### 4. Explore NodeHive Space (`explore-nodehive-space`)
Provides a comprehensive overview of a NodeHive Space including menus, content, and statistics.

**Parameters:**
- `space_id` (required): The ID of the space to explore
- `include_content` (optional): Include detailed content information (default: true)
- `include_menus` (optional): Include menu structure and sitemap (default: true)
- `content_limit` (optional): Maximum number of content items to return (default: 50)

## Resources

The module also provides MCP resources:

- `spaces`: List of all NodeHive Spaces
- `space/{id}`: Individual space details

## Configuration

The module provides several configuration options:

- **Allow Space Creation**: Enable/disable space creation tool
- **Allow Space Updates**: Enable/disable space update tool
- **Allow Space Listing**: Enable/disable space listing tool
- **Allow Space Exploration**: Enable/disable space exploration tool
- **Default Space Type**: Default type for new spaces (full_website, directory, database, other)
- **Default Content Limit**: Default number of content items in exploration (1-1000)

## Installation

1. Install the MCP module: `composer require drupal/mcp`
2. Enable the NodeHive MCP module: `drush en nodehive_mcp`
3. Configure permissions for "use nodehive mcp tools"
4. Configure the plugin at `/admin/config/services/mcp`

## Permissions

- `use nodehive mcp tools`: Allows users to access the MCP tools
- `administer nodehive mcp`: Allows users to configure the MCP plugin

## Usage Examples

### Create a Space
```json
{
  "label": "My New Site",
  "space_url": "https://mynewsite.com",
  "space_type": "full_website",
  "tags": ["production", "website"]
}
```

### List Spaces with Filters
```json
{
  "space_type": "full_website",
  "limit": 10,
  "status": true
}
```

### Explore a Space
```json
{
  "space_id": 123,
  "include_content": true,
  "include_menus": true,
  "content_limit": 25
}
```

## Requirements

- Drupal 10.x
- NodeHive Core module
- MCP module

## Security

The module includes proper access control and permission checks. Users must have the appropriate permissions to use MCP tools, and the plugin can be configured to disable specific functionality if needed.
