# NodeHive Sitemap Visualizer

A Drupal module that provides visual sitemap functionality for NodeHive spaces, allowing users to see the hierarchical structure of their website content.

## Features

- **Visual Sitemap**: Displays a hierarchical view of website structure
- **Menu Integration**: Shows content organized by menus referenced in the space
- **Node Cards**: Beautiful mini cards showing node title, content type, and URL slug
- **Orphaned Content**: Identifies content not linked in any menu
- **Interactive Features**:
  - Expand/collapse sections and tree items
  - Search functionality across nodes and menu items
  - Responsive design for mobile devices

## Installation

1. Enable the module through the Drupal admin interface or via Drush:
   ```bash
   drush en nodehive_sitemap_visualizer
   ```

2. Clear caches:
   ```bash
   drush cr
   ```

## Usage

1. Navigate to any NodeHive space: `/space/{space_id}`
2. Click on the "Sitemap" tab
3. View the hierarchical structure of your website
4. Use the search box to find specific content
5. Use expand/collapse controls to navigate the structure

## Requirements

- NodeHive Core module
- NodeHive Core Space Dashboard module
- Drupal 10 or 11

## Structure

The sitemap displays content in the following sections:

### Menus
- Shows all menus referenced by the space
- Displays menu items hierarchically
- Highlights nodes linked in menus with detailed cards

### Orphaned Content
- Shows content that belongs to the space but isn't linked in any menu
- Helps identify content that might need to be added to navigation

### Node Cards
Each node is displayed as a card containing:
- **Title**: Clickable link to view the node
- **Status**: Published/unpublished indicator
- **Content Type**: Labeled badge showing the content type
- **URL Slug**: The node's URL path
- **Actions**: Edit and view links

## Technical Details

### Files Structure
```
nodehive_sitemap_visualizer/
├── src/
│   └── Controller/
│       └── SitemapController.php
├── templates/
│   └── nodehive-sitemap.html.twig
├── css/
│   └── sitemap.css
├── js/
│   └── sitemap.js
├── nodehive_sitemap_visualizer.info.yml
├── nodehive_sitemap_visualizer.routing.yml
├── nodehive_sitemap_visualizer.links.task.yml
├── nodehive_sitemap_visualizer.libraries.yml
├── nodehive_sitemap_visualizer.module
└── README.md
```

### Key Components

- **SitemapController**: Main controller that builds the sitemap data structure
- **Theme System**: Custom Twig template for rendering the sitemap
- **JavaScript**: Interactive features for expand/collapse and search
- **CSS**: Modern styling with responsive design

## Customization

### Styling
The module uses CSS custom properties and can be easily customized by overriding the styles in your theme.

### Template Override
You can override the template by copying `nodehive-sitemap.html.twig` to your theme's templates directory.

### Extending Functionality
The module provides hooks and can be extended through custom modules.

## Browser Support

- Chrome 60+
- Firefox 55+
- Safari 12+
- Edge 79+

## License

This module is licensed under the same terms as Drupal core.
