<?php

namespace Drupal\nodehive_core\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Routing\RouteMatchInterface;

/**
 * Controller for displaying release notes.
 */
class ReleaseNotesController extends ControllerBase
{

  /**
   * The route match.
   *
   * @var \Drupal\Core\Routing\RouteMatchInterface
   */
  protected $routeMatch;

  /**
   * Constructs a ReleaseNotesController object.
   *
   * @param \Drupal\Core\Routing\RouteMatchInterface $route_match
   *   The route match.
   */
  public function __construct(RouteMatchInterface $route_match)
  {
    $this->routeMatch = $route_match;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container)
  {
    return new static(
      $container->get('current_route_match')
    );
  }

  /**
   * Displays the release notes page.
   *
   * @return array
   *   A render array for the release notes page.
   */
  public function content()
  {
    $build = [
      '#type' => 'inline_template',
      '#template' => '
        <div class="nodehive-release-notes">
          <h2>{{ "17. June 2025"|t }}</h2>
          <div class="release-notes-content">
              <h3>New features and improvements</h3>
              <ul>
                <li>Content Finder: New content finder module which allows you to find content in the NodeHive.</li>
                <li>Autologin on frontend - if you use the updated https://github.com/NETNODEAG/nodehive-nextjs-minimal-starter.</li>
                <li>Small visual improvements.</li>
              </ul>
          </div>
          <h2>{{ "19. May 2025"|t }}</h2>
          <div class="release-notes-content">
              <h3>New features and improvements</h3>
              <ul>
                <li>Dashboard: Content activity dashboard widget is more informative and better structured.</li>
                <li>Dashboard: Visual improvements of several dashboard widgets.</li>
                <li>Improved visual editor with better tab naming and improved UX.</li>
                <li>Improved strucutred content view of nodes.</li>
                <li>Improved breadcrumb links on several admin pages.</li>
                <li>New "Release Notes" page which informs about new features and improvements.</li>
              </ul>
          </div>
        </div>
      ',
    ];

    return $build;
  }

}
