<?php

namespace Drupal\nonce_generator\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a nonce script plugin annotation object.
 *
 * Plugin annotations are used to provide metadata about plugins to the
 * plugin discovery system.
 *
 * @see \Drupal\nonce_generator\Plugin\NonceScriptPluginManager
 * @see plugin_api
 *
 * @Annotation
 */
class NonceScript extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public string $id;

  /**
   * The label of the plugin.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $label;

  /**
   * The weight of the plugin for ordering.
   *
   * Lower weights are executed first.
   *
   * @var int
   */
  public int $weight = 0;

}
