<?php

namespace Drupal\nonce_generator\Plugin\NonceScript;

use Drupal\Core\Plugin\PluginBase;

/**
 * Base class for nonce script plugins.
 *
 * Provides default implementations for common plugin functionality
 * while requiring subclasses to implement the getScript() method.
 */
abstract class NonceScriptPluginBase extends PluginBase implements NonceScriptPluginInterface {

  /**
   * {@inheritdoc}
   */
  public function getLabel(): string {
    return (string) ($this->pluginDefinition['label'] ?? $this->getPluginId());
  }

  /**
   * {@inheritdoc}
   */
  public function getWeight(): int {
    return (int) ($this->pluginDefinition['weight'] ?? 0);
  }

  /**
   * {@inheritdoc}
   */
  public function isApplicable(): bool {
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  abstract public function getScript(string $nonce): string;

}
