<?php

namespace Drupal\nonce_generator\Plugin\NonceScript;

use Drupal\Component\Plugin\PluginInspectionInterface;

/**
 * Interface for nonce script plugins.
 *
 * Provides an interface for plugins that generate script tags with nonce
 * attributes for Content Security Policy compliance.
 */
interface NonceScriptPluginInterface extends PluginInspectionInterface {

  /**
   * Gets the script content with the nonce injected.
   *
   * @param string $nonce
   *   The nonce to inject into the script.
   *
   * @return string
   *   The script content with nonce attributes added.
   */
  public function getScript(string $nonce): string;

  /**
   * Gets the plugin label.
   *
   * @return string
   *   The plugin label.
   */
  public function getLabel(): string;

  /**
   * Gets the plugin weight for ordering.
   *
   * @return int
   *   The plugin weight.
   */
  public function getWeight(): int;

  /**
   * Checks if this plugin should be rendered for the current request.
   *
   * @return bool
   *   TRUE if the plugin should be rendered, FALSE otherwise.
   */
  public function isApplicable(): bool;

}
