import { EventStore } from "applesauce-core";
import { Relay, RelayPool } from 'applesauce-relay';
import { EventFactory } from 'applesauce-factory';
import { NostrConnectSigner } from 'applesauce-signers';

(function (Drupal, drupalSettings) {
  "use strict";

  // Global namespace for the AppleSauce which will be initialized.
  Drupal.AppleSauce = Drupal.AppleSauce || {};

  Drupal.behaviors.nostr_applesauce = {
    attach: async function(context, settings) {
      for (const doc of once('init-once', context === document ? 'html' : context)) {
        if (doc.tagName === 'HTML' || doc.tagName === 'BODY') {
          await init()
        }
      }
    }
  }

  const init = async () => {
    const store = new AppleSauceStore();
    // EventStore package
    Drupal.AppleSauce.eventStore = new EventStore();
    Drupal.AppleSauce.relay = new Relay();
    const pool = new RelayPool();
    Drupal.AppleSauce.relayPool = pool;
    Drupal.AppleSauce.eventFactory = new EventFactory();
    NostrConnectSigner.subscriptionMethod = pool.subscription.bind(pool);
    NostrConnectSigner.publishMethod = pool.publish.bind(pool);
    Drupal.AppleSauce.nostrConnectSigner = NostrConnectSigner;
    Drupal.AppleSauce.globalStore = store;
  }

}) (Drupal, drupalSettings);

/**
 * AppleSauceStore singleton class for a key-value store.
 */
class AppleSauceStore {
  /**
   * Constructor.
   *
   * @returns {AppleSauceStore}
   */
  constructor() {
    if(!AppleSauceStore.instance) {
      this._data = {};
      AppleSauceStore.instance = this;
    }
    return AppleSauceStore.instance;
  }

  /**
   * Setter.
   *
   * @param key
   * @param value
   */
  set(key, value){
    this._data[key] = value;
  }

  /**
   * Getter.
   *
   * @param key
   * @returns {*}
   */
  get(key){
    return this._data[key];
  }

  /**
   * Delete an entry.
   *
   * @param key
   */
  delete(key){
    delete this._data[key];
  }
  /**
   * Return all keys in an array.
   * @returns {*[]}
   */
  getAllKeys(){
    const keys = [];
    for (const key in this._data) {
      keys.push(key)
    }
    return keys;
  }
}
