# Notification Message

## Table of Contents

- [Introduction](#introduction)
- [Requirements](#requirements)
- [Installation](#installation)
- [Configuration](#configuration)
- [Usage](#usage)
- [Troubleshooting](#troubleshooting)
- [FAQ](#faq)
- [Maintainers](#maintainers)

## Introduction

The Notification Message module allows site administrators to broadcast
notification messages throughout a Drupal site. Messages support time-based
publishing with start and end dates, and conditional display using Drupal's
Condition API.

Common use cases include:

- Site-wide outage or maintenance announcements
- Promotional banners during specific time periods
- Role-targeted notifications for specific user groups
- Context-aware messages on specific content types
- Dismissible alerts that persist across sessions

**Features:**

- Create multiple notification message types for different use cases
- Time-based publishing with configurable start and end dates
- Conditional display using Drupal's Condition API (user roles, paths, etc.)
- Dismissible messages with cookie-based persistence
- Block-based display with configurable view modes
- Field API support for custom fields on message types
- Full translation support for multilingual sites

For a full description of the module, visit the
[project page](https://www.drupal.org/project/notification_message).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/notification_message).

## Requirements

This module requires the following Drupal core modules:

- Text
- Block
- Datetime

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

1. **Set the site timezone** at Administration > Configuration > Regional and
   language > Regional settings (`/admin/config/regional/settings`). The module
   uses the site timezone when publishing and unpublishing messages.

2. **Configure user permissions** at Administration > People > Permissions:

- *Administer notification message types* - Manage message type structure,
  add fields, and configure form/view displays.
- *Administer notification message content* - Create, edit, and delete
  notification messages.
- *View any unpublished notification message* - Preview messages before
  their publish date.
- *View own unpublished notification message* - View only unpublished
  messages the user authored.

3. **Create notification message types** at Administration > Structure >
   Notification message types (`/admin/structure/notification-message-types`):

- The module ships with a default "Global" message type.
- Create additional types to support different use cases.
- Configure which conditions are available per type using the "allowed data
  types" setting.
- Enable the dismiss button and customize button text if needed.

4. **Place the block** at Administration > Structure > Block layout
   (`/admin/structure/block`):

- Click "Place block" in the desired region.
- Select "Notification Messages" from the block list.
- Choose a display mode for rendering messages.
- Optionally filter by specific message types.

## Usage

### Creating a Notification Message

1. Navigate to Administration > Content > Notification Message
   (`/admin/content/notification-message`).
2. Click "Add notification message" and select a message type.
3. Enter the message label and content.
4. Set the publish start and end dates (end date defaults to 2 days from now).
5. Configure conditions if needed (e.g., show only to authenticated users).
6. Save the message.

### Condition Logic

When configuring multiple conditions on a message:

- **All conditions required** (AND logic) - Message shows only when ALL
  conditions are met.
- **Any condition sufficient** (OR logic) - Message shows when at least ONE
  condition is met.

Each individual condition can be negated to reverse its logic.

### Dismissible Messages

When enabled on a message type:

- A close button appears on messages of that type.
- Dismissed messages are stored in a browser cookie.
- Dismissals are announced to screen readers via ARIA live regions.

## Troubleshooting

**Messages not appearing:**

- Verify the current date/time falls within the message's publish date range.
- Check that conditions are configured correctly (test with no conditions
  first).
- Ensure the block is placed and visible in block layout.
- Clear the Drupal cache after making configuration changes.

**Messages not disappearing after end date:**

- Run cron manually at Administration > Reports > Status report
  (`/admin/reports/status`).
- The module invalidates expired message caches during cron runs.

**Dismissed messages reappearing:**

- Users may have cleared browser cookies.
- Verify JavaScript is enabled and loading correctly.
- Check browser console for JavaScript errors.

## FAQ

**Q: Can I add custom fields to notification messages?**

A: Yes. Navigate to the message type's "Manage fields" tab to add fields via
the Field UI.

**Q: How do I target messages to specific pages?**

A: Use the "Request Path" condition (from Drupal core) when creating a message.
Specify paths where the message should appear.

**Q: Can messages appear on specific content types only?**

A: Yes. Use node type conditions. Ensure your message type has `entity:node`
in its allowed condition data types.

**Q: How is caching handled?**

A: The module uses cache tags and contexts for proper invalidation. Messages
are cached per route and user context. Expired messages are invalidated via
cron.

**Q: Can I create custom conditions?**

A: Yes. Implement a custom condition plugin following Drupal's Condition API.
The module will automatically detect and offer it for use.
