<?php

declare(strict_types=1);

namespace Drupal\notification_message\Entity\Routing;

use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Entity\Routing\DefaultHtmlRouteProvider;

/**
 * Define notification message HTML route provider.
 */
class NotificationMessageHtmlRouteProvider extends DefaultHtmlRouteProvider {

  /**
   * {@inheritdoc}
   */
  protected function getCollectionRoute(EntityTypeInterface $entity_type) {
    $route = parent::getCollectionRoute($entity_type);
    if ($route !== NULL) {
      $route->setDefault('_title', '@label');
    }

    return $route;
  }

}
