<?php

declare(strict_types=1);

namespace Drupal\notification_message\Entity;

use Drupal\Core\Entity\EntityDescriptionInterface;
use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Define the notification message type interface.
 */
interface NotificationMessageTypeInterface extends ConfigEntityInterface, EntityDescriptionInterface {

  /**
   * Get notification message type help description.
   *
   * @return string
   *   The notification message type help description.
   */
  public function getHelpDescription();

  /**
   * Get the notification message type allow condition flag.
   *
   * @return bool
   *   Return TRUE if conditions are allowed; otherwise FALSE.
   */
  public function getAllowCondition();

  /**
   * Get the notification message type allowed condition data types.
   *
   * @return array
   *   An array of allowed data types to filter the conditions.
   */
  public function getConditionDatatype();

  /**
   * Get the notification message type dismiss settings.
   *
   * @return array
   *   An array of the notification dismiss settings.
   */
  public function getNotificationDismiss();

  /**
   * Get notification dismiss show value.
   *
   * @return bool
   *   Return a boolean based on if notification dismiss is enabled.
   */
  public function getNotificationDismissShow(): bool;

  /**
   * Get notification dismiss button text.
   *
   * @return string|null
   *   The notification dismiss button text.
   */
  public function getNotificationDismissButtonText(): ?string;

  /**
   * Has associated notification messages based on the message type.
   *
   * @throws \Drupal\Component\Plugin\Exception\InvalidPluginDefinitionException
   * @throws \Drupal\Component\Plugin\Exception\PluginNotFoundException
   *
   * @return bool
   *   Return TRUE if associated data exist; otherwise FALSE.
   */
  public function hasAssociatedData(): bool;

}
