# Requirements

This page outlines the system requirements for the Notification Server module.

## Drupal Requirements

### Drupal Version
- **Drupal 10.x** or **Drupal 11.x**
- Compatible with both major versions

### PHP Requirements

!!! warning "PHP Version Requirement"

    **PHP 8.1** or higher is required for modern PHP features and type declarations used throughout the codebase. Older PHP versions are not supported.

## External Dependencies

!!! warning "Critical Dependencies"
    The Notification Server module **cannot function** without these external components.

### Notification Server

- **Required**: A running instance of the [Notification Server](https://github.com/d34dman/notification-server)
- **Role**: Provides the actual WebSocket server and HTTP API endpoints
- **Language**: Node.js application
- **Ports**: Requires two accessible ports (default: 3000 for HTTP, 8080 for WebSocket)

### Redis Server

- **Required**: Redis server for data storage
- **Version**: Redis 6.0 or higher recommended
- **Usage**: Key-value storage for channel data, client information, and message history
- **Note**: Redis pub/sub functionality is **not** used by this implementation

## Network Requirements

### Port Accessibility

!!! info "Required Ports"

    The notification server requires the following ports to be accessible:

    - **Port 3000** (HTTP API) - For publishing notifications and managing channels
    - **Port 8080** (WebSocket) - For real-time client connections
    - **Port 6379** (Redis) - For data storage (can be different if Redis is remote)

### Firewall Configuration

!!! warning "Firewall Requirements"

    Ensure your firewall allows:
    
    - Inbound connections to the notification server ports
    - Outbound connections from Drupal to the notification server
    - Connections between the notification server and Redis

## Browser Compatibility

### WebSocket Support

!!! info "Browser Compatibility"

    Modern browsers with WebSocket support:
    
    - **Chrome**: Version 16+
    - **Firefox**: Version 11+
    - **Safari**: Version 7+
    - **Edge**: Version 12+
    - **Internet Explorer**: Version 10+ (limited support)

### JavaScript Requirements

- **ES6 features**: Modern JavaScript for WebSocket handling
- **JSON support**: For message serialization/deserialization
- **Promise support**: For async operations (recommended)

## Server Environment

### Recommended Specifications

For production environments:

- **CPU**: 2+ cores recommended
- **RAM**: 4GB+ recommended (depends on concurrent connections)
- **Storage**: SSD recommended for Redis performance
- **Network**: Low latency between Drupal and notification server

### Development Environment

Minimum specifications for development:

- **CPU**: 1+ core
- **RAM**: 2GB+
- **Storage**: Any (HDD acceptable)
- **Network**: Local network sufficient

## Security Considerations

### Network Security

!!! warning "Production Security"

    For production environments:
    
    - Use **TLS/SSL** for production WebSocket connections (`wss://`)
    - Secure Redis connections if running on separate servers
    - Implement proper firewall rules
    - Consider VPN for server-to-server communication

### Application Security

- Validate all client IDs and channel names
- Implement rate limiting at the application level
- Monitor for suspicious connection patterns
- Regular security updates for all components

## Performance Requirements

### Connection Limits

The notification server can handle:
- **Concurrent WebSocket connections**: Thousands (depends on server resources)
- **HTTP requests per second**: High throughput (depends on Redis performance)
- **Message throughput**: High volume messaging support

### Redis Performance

- **Memory**: Allocate sufficient RAM for your expected data volume
- **Persistence**: Configure appropriate Redis persistence settings
- **Monitoring**: Monitor Redis memory usage and performance

## Development Tools

### Required for Development

- **Composer**: For managing PHP dependencies
- **Drush**: For module management and configuration
- **Node.js**: For running the notification server locally
- **npm**: For notification server dependencies

### Recommended Development Tools

!!! tip "Development Tools"

    These tools will significantly improve your development experience:
    
    - **DDEV**: Simplifies development environment setup
    - **Git**: Version control
    - **IDE/Editor**: With PHP and JavaScript support
    - **Browser Developer Tools**: For WebSocket debugging

## Testing Requirements

### Automated Testing

- **PHPUnit**: For Drupal module testing
- **Jest**: For notification server testing (if modifying server code)
- **Browser automation**: For WebSocket functionality testing

### Manual Testing

- **Multiple browsers**: Test WebSocket compatibility
- **Network simulation**: Test connection drops and reconnections
- **Load testing**: Verify performance under load

## Monitoring and Logging

### Log Management

Ensure proper logging for:
- **Drupal logs**: Module-specific error reporting
- **Notification server logs**: Connection and message logs
- **Redis logs**: Performance and error monitoring
- **Web server logs**: Access and error logs

### Monitoring Tools

Consider implementing:
- **Application Performance Monitoring (APM)**
- **Redis monitoring** (memory, connections, performance)
- **WebSocket connection monitoring**
- **Health checks** for all components

## Version Compatibility

### Supported Versions

| Component | Minimum Version | Recommended Version |
|-----------|----------------|-------------------|
| Drupal | 10.0 | Latest stable |
| PHP | 8.1 | 8.2+ |
| Node.js | 16.0 | 18.0+ |
| Redis | 6.0 | 7.0+ |
| npm | 8.0 | Latest |

### Upgrade Considerations

- **Drupal updates**: Follow standard Drupal update procedures
- **PHP updates**: Test thoroughly before upgrading PHP versions
- **Notification server updates**: Check for breaking changes in API
- **Redis updates**: Monitor for performance improvements

## Platform Support

### Operating Systems

**Linux** (Recommended)
- Ubuntu 20.04+
- CentOS 8+
- Debian 11+
- Amazon Linux 2

**macOS** (Development)
- macOS 11+ (Big Sur)
- Homebrew for package management

**Windows** (Development)
- Windows 10+
- WSL2 recommended for Linux compatibility

### Cloud Platforms

Tested and compatible with:
- **AWS**: EC2, ECS, Lambda (for serverless setups)
- **Google Cloud**: Compute Engine, Cloud Run
- **Azure**: Virtual Machines, Container Instances
- **DigitalOcean**: Droplets, App Platform
- **Docker**: Full containerization support
