# Notification Server

![Gitlab Pipeline Status](https://img.shields.io/gitlab/pipeline-status/project%2Fnotification_server?gitlab_url=https%3A%2F%2Fgit.drupalcode.org&branch=1.x&style=flat-square&logo=gitlab) 
![GitLab Tag](https://img.shields.io/gitlab/v/tag/project%2Fnotification_server?gitlab_url=https%3A%2F%2Fgit.drupalcode.org&style=flat-square) 
![GitLab Contributors](https://img.shields.io/gitlab/contributors/project%2Fnotification_server?gitlab_url=https%3A%2F%2Fgit.drupalcode.org&style=flat-square)
[![Documentation](https://img.shields.io/badge/docs-gitlab%20pages-blue)](https://project.pages.drupalcode.org/notification_server/)
[![PHP Version](https://img.shields.io/badge/php-%3E%3D8.1-blue)](https://www.php.net/)
[![Drupal](https://img.shields.io/badge/drupal-10.x%20%7C%2011.x-green)](https://www.drupal.org)

A Drupal module that provides real-time notification capabilities by integrating with an external notification server through HTTP and WebSocket protocols.

## Quick Start

### 1. Install Dependencies

**For DDEV users (Recommended):**

```bash
# Add notification server addon to your DDEV project
ddev add-on get d34dman/ddev-notification-server
ddev restart
```

**For Docker users:**

```bash
# Run notification server and Redis
docker run -d --name redis redis:alpine
docker run -d --name notification-server -p 3000:3000 -p 8080:8080 \
  -e REDIS_URL=redis://redis:6379 \
  --link redis \
  ghcr.io/d34dman/notification-server:main
```

### 2. Install Module

```bash
# Install via Composer
composer require drupal/notification_server

# Enable the module
drush en notification_server

# Optional: Enable demo module for testing
drush en notification_server_demo
```

### 3. Configure

1. Visit `/admin/config/system/notification-server`
2. Set server URLs:
   - **DDEV**: Server URL: `http://notification-server:3000`, WebSocket: `ws://notification-server:8080`
   - **Docker**: Server URL: `http://localhost:3000`, WebSocket: `ws://localhost:8080`

### 4. Test

```php
<?php
// Send your first notification
$client = \Drupal::service('notification_server.client');
$client->publishNotification('test_channel', 'Hello, World!');
```

## What This Module Does

> **Important**: This is a **developer module** that provides APIs and services. It requires custom code or other modules to utilize its functionality.

- ✅ **HTTP API Client** - Publish notifications and manage channels
- ✅ **WebSocket Integration** - Real-time bidirectional communication
- ✅ **Channel Management** - Create channels with access control
- ✅ **Client Management** - Handle WebSocket client connections

Perfect for: Real-time dashboards, chat applications, live updates, push notifications, content moderation workflows.

## Dependencies

- **External Notification Server**: [notification-server](https://github.com/d34dman/notification-server) (Node.js app)
- **Redis**: Required by the notification server for data storage
- **Drupal**: 10.x or 11.x
- **PHP**: 8.1 or higher

## Documentation

**[Complete Documentation](https://d34dman.gitlab.io/notification_server/)**

- [Features](https://d34dman.gitlab.io/notification_server/Features/) - Detailed feature overview
- [Requirements](https://d34dman.gitlab.io/notification_server/Requirements/) - System requirements
- [Quick Reference](https://d34dman.gitlab.io/notification_server/QuickReference/) - Installation and usage guide
- [API Reference](https://d34dman.gitlab.io/notification_server/APIReference/) - Complete API documentation
- [Troubleshooting](https://d34dman.gitlab.io/notification_server/Troubleshooting/) - Common issues and solutions

## Demo

Enable the demo module to try out the functionality:

```bash
drush en notification_server_demo
```

Then visit:
- **HTTP Demo**: `/admin/config/system/notification-server/http-demo`
- **WebSocket Demo**: `/admin/config/system/notification-server/websocket-demo`

## Related Projects

- **[Notification Server](https://github.com/d34dman/notification-server)** - The external server (Node.js)
- **[DDEV Addon](https://addons.ddev.com/addons/d34dman/ddev-notification-server)** - Easy DDEV integration

## Self-Hosted Alternative

This is a **self-hosted solution** providing an alternative to SaaS services like Pusher, Firebase, or Ably. Benefits:

- ✅ Full control over your data
- ✅ No vendor lock-in
- ✅ Customizable to your needs
- ✅ Cost-effective for high-volume usage

## Support

- **Module Issues**: Use the [Drupal.org issue queue](https://www.drupal.org/project/issues/notification_server)
- **Server Issues**: [GitHub Issues](https://github.com/d34dman/notification-server/issues)
- **Documentation**: [GitLab Pages](https://project.pages.drupalcode.org/notification_server/)

---

**[Read the full documentation](https://project.pages.drupalcode.org/notification_server/)** for detailed installation instructions, API reference, and examples.