<?php

namespace Drupal\notification_server_demo\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Config\ConfigFactoryInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Controller for WebSocket notification demo.
 */
final class NotificationWebSocketDemoController extends ControllerBase {

  /**
   * The config factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * Constructs a new NotificationWebSocketDemoController.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory.
   */
  public function __construct(ConfigFactoryInterface $config_factory) {
    $this->configFactory = $config_factory;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('config.factory')
    );
  }

  /**
   * Builds the WebSocket notification demo page.
   *
   * @return array
   *   A render array representing the WebSocket notification demo page.
   */
  public function content() {
    $build = [
      '#theme' => 'notification_websocket_demo',
      '#attached' => [
        'library' => ['notification_server_demo/websocket_demo'],
        'drupalSettings' => [
          'notificationServer' => [
            'websocketUrl' => $this->getWebSocketUrl(),
          ],
        ],
      ],
      '#attributes' => [
        'class' => ['websocket-demo'],
      ],
    ];

    return $build;
  }

  /**
   * Gets the WebSocket server URL.
   *
   * @return string
   *   The WebSocket server URL.
   */
  private function getWebSocketUrl() {
    $config = $this->configFactory->get('notification_server.settings');
    return $config->get('websocket_url');
  }

}
